/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MBGEOMETRYREGULAR_H
#define _MBGEOMETRYREGULAR_H

#ifdef _WIN32
#pragma warning(push)
#pragma warning(disable:4250)
#pragma warning(disable:4251)
#endif

#include <MeshVizXLM/mesh/geometry/MiGeometryRegular.h>
#include <geometry/MbGeometry.h>

/**
* @DTEXT Generic parallelepiped, rectangular or straight line geometry.
* 
* @ingroup MeshVizXLM_Implement_Geometry
* 
* @DESCRIPTION
*    The geometry is given by 2 points defining 2 extremities.
* 
*/
template <typename _T=double>
class MbGeometryRegular : public MiGeometryRegular, public MbGeometry
{
public:
  /** Constructor */
  MbGeometryRegular(MbVec3<_T> min, MbVec3<_T> max)
    : m_min(min), m_max(max)
  {
  }

  MbGeometryRegular(_T xmin, _T ymin, _T zmin, 
                    _T xmax, _T ymax, _T zmax) 
    : m_min(xmin,ymin,zmin), m_max(xmax,ymax,zmax)
  {
  }

  /**
  * Return the min point of this parallelepiped.
  */
  virtual MbVec3d getMin() const { return m_min; }

  /**
  * Return the max point of this parallelepiped.
  */
  virtual MbVec3d getMax() const { return m_max; }

protected:
  MbVec3d m_min;
  MbVec3d m_max;

};

#ifdef _WIN32
#pragma warning(pop)
#endif

#endif


