/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MBSURFACEGEOMETRYRECTILINEAR_H
#define _MBSURFACEGEOMETRYRECTILINEAR_H

#ifdef _WIN32
#pragma warning(push)
#pragma warning(disable:4250)
#pragma warning(disable:4251)
#endif

#include <MeshVizXLM/mesh/geometry/MiSurfaceGeometryRectilinear.h>
#include <geometry/MbGeometry.h>
#include <MbError.h>

#include <Inventor/STL/vector>
#include <Inventor/STL/algorithm>

/**
* @DTEXT Generic parallelepiped geometry.
* 
* @ingroup MeshVizXLM_Implement_Geometry
* 
* @DESCRIPTION
*    A generic abstract interface for a rectilinear geometry. 
* 
*/
template <typename _T=double>
class MbSurfaceGeometryRectilinear : public MiSurfaceGeometryRectilinear, public MbGeometry
{
public:
  /** Constructor */
  template <typename _NodeIdIter>
  MbSurfaceGeometryRectilinear(_NodeIdIter xBegin,_NodeIdIter xEnd, 
                               _NodeIdIter yBegin,_NodeIdIter yEnd)
  {
    m_x.assign(xBegin,xEnd);
    m_y.assign(yBegin,yEnd);
    if (!m_x.empty() && !m_y.empty())
    {
      m_min.setValue(*std::min_element(m_x.begin(), m_x.end()),
        *std::min_element(m_y.begin(), m_y.end()),
        (_T)0);
      m_max.setValue(*std::max_element(xBegin, xEnd),
        *std::max_element(yBegin, yEnd),
        (_T)0);
    }
  }

  /**
  * Returns the X coordinate of this geometry.
  */
  virtual double getX(size_t i) const
  {
#ifndef MBMESH_DONT_USE_ASSERT
    if (m_x.size() <= i)
      throw MbError("accessing coordinate out of range");
#endif
    return m_x[i];
  }
  /**
  * Returns the X coordinate of this geometry.
  */
  virtual double getY(size_t j) const
  {
#ifndef MBMESH_DONT_USE_ASSERT
    if (m_y.size() <= j)
      throw MbError("accessing coordinate out of range");
#endif
    return m_y[j];
  }

  /**
  * Return the min point of this parallelepiped.
  */
  MbVec3d getMin() const { return (MbVec3d) m_min;}
  /**
  * Return the max point of this parallelepiped.
  */
  MbVec3d getMax() const { return (MbVec3d) m_max;}

protected:
  std::vector<_T> m_x;
  std::vector<_T> m_y;
  MbVec3<_T> m_min;
  MbVec3<_T> m_max;

};

#ifdef _WIN32
#pragma warning(pop)
#endif

#endif


