#ifndef  _PEBIGeometry_H
#define  _PEBIGeometry_H

#include <MeshVizXLM/mesh/geometry/MiGeometryI.h>
#include <MeshVizXLM/MbVec3.h>
#include <MeshVizXLM/MxTimeStamp.h>

#include <Inventor/STL/limits>
#include <Inventor/STL/algorithm>

class PEBIGeometry : public MiGeometryI
{
public:
  PEBIGeometry( size_t numLayer, float elevation )
    : m_numLayer( numLayer )
    , m_elevation( elevation )
    , m_timeStamp( MxTimeStamp::getTimeStamp() )
    , m_min( std::numeric_limits<double>::max() )
    , m_max( 0 )
  {
  }

  void touch()
  {
    m_timeStamp = MxTimeStamp::getTimeStamp();
  }

  size_t getTimeStamp() const { return m_timeStamp; }

  MbVec3d getMin() const;
  MbVec3d getMax() const;

  MbVec3d getCoord(size_t i) const 
  {
    size_t nbVertices = m_surfaceVertexPositions.size();
	size_t index_cell2D = i % nbVertices;
	size_t index_layer = i / nbVertices;
	MbVec3f offset(0);
	offset[2] =  index_layer/m_elevation;
    MbVec3f coord2D = m_surfaceVertexPositions[index_cell2D];
	MbVec3d coord3D(coord2D + offset);

	return coord3D;
  }

  void resize(size_t numSurfaceVertices)
  {
    m_surfaceVertexPositions.resize(numSurfaceVertices);
    m_timeStamp = MxTimeStamp::getTimeStamp();
  }

  void setSurfaceVertex(size_t i, const MbVec3f& v)
  {
    m_surfaceVertexPositions[i] = v;
    m_min[0] = std::min(m_min[0],(double)v[0]);
    m_min[1] = std::min(m_min[1],(double)v[1]);
    m_min[2] = std::min(m_min[2],(double)v[2]);
    m_max[0] = std::max(m_max[0],(double)v[0]);
    m_max[1] = std::max(m_max[1],(double)v[1]);
    m_max[2] = std::max(m_max[2],(double)v[2]);
  }

  size_t getSize() const
  {
    return m_surfaceVertexPositions.size()*m_numLayer;
  }

  size_t getNumLayers() const 
  {
	  return m_numLayer;
  }

private:
  friend class PEBIreader;

  std::vector<MbVec3f> m_surfaceVertexPositions;
  size_t m_numLayer;
  float m_elevation;
  size_t m_timeStamp;

  MbVec3d m_min, m_max;

};

//-----------------------------------------------------------------------------
inline MbVec3d
PEBIGeometry::getMin() const
{
  return m_min;
}


//-----------------------------------------------------------------------------
inline MbVec3d
PEBIGeometry::getMax() const
{ 
  return (m_max + MbVec3d(0,0,(double)m_numLayer/(double)m_elevation));
}


#endif







