#ifndef  _WheelGeometry_h
#define  _WheelGeometry_h

#include <cstdlib>
#include <cmath>

#include <MeshVizXLM/mesh/geometry/MiGeometryI.h>
#include <MeshVizXLM/MxTimeStamp.h>

#include <Inventor/SbBox.h>

#include <Inventor/STL/vector>

//-----------------------------------------------------------------------------
class WheelGeometry : public MiGeometryI
{
public:
  WheelGeometry(size_t numCellR, size_t numCellA, size_t numCellB);
  const std::vector<MbVec3d>& getCoords() const
  {
    return m_coords;
  }

  void setGeometry(double rmin, double rmax, double alphaMin, double alphaMax, double zMin, double zMax);

  virtual MbVec3d getCoord(size_t i) const 
  {
    return m_coords[i];
  }

  virtual MbVec3d getMin() const 
  {
    return MbVec3d(m_bbox.getMin());
  }
  /**
  * Returns the maximum value of this set.
  */
  virtual MbVec3d getMax() const 
  {
    return MbVec3d(m_bbox.getMax());
  }

  virtual size_t getTimeStamp() const 
  {
    return m_timestamp;
  }

  void touch()
  {
    m_timestamp = MxTimeStamp::getTimeStamp();
  }

private:
  MbVec3d getCartesianCoord(double r, double a, double b)
  {
    SbVec3d s = m_bbox.getSize();
    MbVec3d res(r*std::cos(a)*std::cos(b),r*std::sin(b),r*std::cos(b)*std::sin(a));
    if ( std::abs(res[0]) / s[0] < 1e-5) res[0] = 0.0;
    if ( std::abs(res[1]) / s[1] < 1e-5) res[1] = 0.0;
    if ( std::abs(res[2]) / s[2] < 1e-5) res[2] = 0.0;
    return res;
  }

  size_t m_numNodeR, m_numNodeA, m_numNodeB;
  std::vector<MbVec3d> m_coords;

  SbBox3d m_bbox;
  size_t m_timestamp;
};


#endif 


