/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef  _MBMESH_H
#define  _MBMESH_H

#ifdef _WIN32
#  pragma warning( push )
#  pragma warning(disable:4250)
#endif

#include <MeshVizXLM/mesh/MiMeshUnstructured.h>
#include <MeshVizXLM/mesh/data/MiDataSetI.h>

#include <MbMeshVizImpl.h>
#include <data/MbDataSetStorageI.h>
#include <geometry/MbMeshGeometry.h>

#include <Inventor/STL/set>
#include <Inventor/STL/algorithm>
#include <Inventor/STL/functional>
#include <Inventor/STL/iostream>

/**
 * @DTEXT Base class for all basic mesh implementation.
 * 
 * @ingroup MeshVizXLM_Implement_Mesh
 * 
 * @DESCRIPTION
 * 
 */
template <typename _CoordT, typename _ScalarT, typename _Vec3T>
class MbMesh : virtual public MiMeshUnstructured, public MbDataSetStorageI<_ScalarT, _Vec3T>
{
public:
  
  virtual const MbMeshGeometry<_CoordT>& getGeometry() const;
  MbMeshGeometry<_CoordT>& getGeometry();

  /**
   * Sets a new geometry
   */
  template <typename _CoordIter>
  void setGeometry(_CoordIter beginCoord, _CoordIter endCoord);

protected:
  virtual std::ostream& toStream(std::ostream& s) const;

  // MbMesh is abstract
  MbMesh();
  template <typename _CoordIter>
  MbMesh(_CoordIter beginCoord, _CoordIter endCoord);
  
  MbMeshGeometry<_CoordT> m_geometry;
};

//-----------------------------------------------------------------------------
template <typename _CoordT, typename _ScalarT, typename _Vec3T>
MbMesh<_CoordT,_ScalarT,_Vec3T>::MbMesh()
{
}

//-----------------------------------------------------------------------------
template <typename _CoordT, typename _ScalarT, typename _Vec3T>
template <typename _CoordIter>
MbMesh<_CoordT,_ScalarT,_Vec3T>::MbMesh(_CoordIter beginCoord, _CoordIter endCoord):
  m_geometry(beginCoord,endCoord)
{
}

//-----------------------------------------------------------------------------
template <typename _CoordT, typename _ScalarT, typename _Vec3T>
template <typename _CoordIter>
inline void 
MbMesh<_CoordT,_ScalarT,_Vec3T>::setGeometry(_CoordIter beginCoord, _CoordIter endCoord)
{
  m_geometry.assign( beginCoord,endCoord );
}

//-----------------------------------------------------------------------------
template <typename _CoordT, typename _ScalarT, typename _Vec3T>
inline const MbMeshGeometry<_CoordT>&
MbMesh<_CoordT,_ScalarT,_Vec3T>::getGeometry() const
{
  return m_geometry;
}

//-----------------------------------------------------------------------------
template <typename _CoordT, typename _ScalarT, typename _Vec3T>
inline MbMeshGeometry<_CoordT>&
MbMesh<_CoordT,_ScalarT,_Vec3T>::getGeometry()
{
  return m_geometry;
}

//-----------------------------------------------------------------------------
template <typename _CoordT, typename _ScalarT, typename _Vec3T>
inline std::ostream& 
MbMesh<_CoordT,_ScalarT,_Vec3T>::toStream(std::ostream& s) const
{
  return MbDataSetStorageI<_ScalarT, _Vec3T>::toStream(s);
}

#ifdef _WIN32
#  pragma warning( pop )
#endif

#endif 







