#ifndef  _QuadraticLineMesh_h
#define  _QuadraticLineMesh_h

#include <MeshVizXLM/mesh/MiLineMeshUnstructured.h>
#include <MeshVizXLM/mesh/data/MiDataSetI.h>

#include <cell/QuadraticLineCell.h>

#include <Inventor/STL/vector>

class QuadraticLineScalardSetI : public MiScalardSetI
{
public:
  QuadraticLineScalardSetI()
  {
    m_data[0] = 0;
    m_data[1] = 0.1;
    m_data[2] = 2;
    m_data[3] = 3.5;
    m_data[4] = 4;
    m_data[5] = 4.5;
    m_data[6] = 6;
  }

  virtual double getMin() const 
  {
    return 0;
  }

  virtual double getMax() const 
  {
    return 6;
  }

  virtual double get(size_t id) const 
  {
    return m_data[id];
  }

  DataBinding getBinding() const
  {
    return PER_NODE;
  }


  virtual size_t getTimeStamp() const 
  {
    return 1;
  }

  virtual std::string getName() const
  {
    return "QuadraticLineScalardSetI";
  }

private:
  double m_data[7];
};

//-----------------------------------------------------------------------------
class QuadraticLineGeometry : public MiGeometryI
{
public:
  QuadraticLineGeometry()
  {
    m_coords.push_back(MbVec3d(-1, 0,0));
    m_coords.push_back(MbVec3d( -1.3,+1.5,0));
    m_coords.push_back(MbVec3d(+1, 0,0));
    m_coords.push_back(MbVec3d(+2,-1,0));
    m_coords.push_back(MbVec3d(+3, 0,0));
    m_coords.push_back(MbVec3d(+2,+1,0));
    m_coords.push_back(MbVec3d(+3,+2,0));
  }

  virtual MbVec3d getCoord(size_t i) const 
  {
    return m_coords[i];
  }

  virtual size_t getTimeStamp() const 
  {
    return 1;
  }

  const std::vector<MbVec3d>& getCoords() const
  {
    return m_coords;
  }

private:
  std::vector<MbVec3d> m_coords;
};


//-----------------------------------------------------------------------------
class QuadraticLineTopology : public MiLineTopologyExplicitI
{
public:
  QuadraticLineTopology() 
    : m_cell0(0,2,1), m_cell1(2,4,3), m_cell2(4,6,5) 
  {
  }

  virtual bool hasDeadCells() const { return true; }
  virtual bool isDead(size_t /*i*/) const { return false; }

  virtual const MiLineCell* getCell(size_t id) const
  {
    switch (id)
    {
    case 0: return &m_cell0;
    case 1: return &m_cell1;
    case 2: 
    default: return &m_cell2;
    }
  }

  virtual size_t getEndNodeId() const
  {
    return 7;
  }

  virtual size_t getNumCells() const
  {
    return 3;
  }

  virtual size_t getTimeStamp() const 
  {
    return 1;
  }

private:
  QuadraticLineCell m_cell0;
  QuadraticLineCell m_cell1;
  QuadraticLineCell m_cell2;

};


//-----------------------------------------------------------------------------
class QuadraticLineMesh : public MiLineMeshUnstructured
{
public:
  QuadraticLineMesh() {}

  virtual const MiLineTopologyExplicitI& getTopology() const 
  {
    return m_topology;
  }

  virtual const MiGeometryI& getGeometry() const 
  {
    return m_geometry;
  }

  const std::vector<MbVec3d>& getCoords() const
  {
    return m_geometry.getCoords();
  }

private:
  QuadraticLineGeometry m_geometry;
  QuadraticLineTopology m_topology;
};



#endif 


