/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MBSURFACEMESHRECTILINEAR_H
#define _MBSURFACEMESHRECTILINEAR_H

#ifdef _WIN32
#  pragma warning( push )
#  pragma warning(disable:4250)
#  pragma warning(disable:4251)
#endif

#include <MeshVizXLM/mesh/MiSurfaceMeshRectilinear.h>
#include <mesh/MbMeshIj.h>

#include <geometry/MbSurfaceGeometryRectilinear.h>

/**
 * @DTEXT class defining a Rectilinear volume mesh.
 * 
 * @ingroup MeshVizXLM_Implement_Mesh
 * 
 * @DESCRIPTION

 * 
 */

template <typename _CoordT=double, typename _ScalarT=double, typename _Vec3T=MbVec3d>
class MbSurfaceMeshRectilinear : virtual public MiSurfaceMeshRectilinear, public MbMeshIj<_ScalarT,_Vec3T>
{
public:
  /** Constructor */
  template <typename _NodeIdIter>
  MbSurfaceMeshRectilinear( _NodeIdIter xBegin,_NodeIdIter xEnd, 
                            _NodeIdIter yBegin,_NodeIdIter yEnd) :
  MbMeshIj<_ScalarT, _Vec3T>(std::distance(xBegin, xEnd) == 0 ? 0 : std::distance(xBegin, xEnd) - 1,
                             std::distance(yBegin, yEnd) == 0 ? 0 : std::distance(yBegin, yEnd) - 1),
  m_geometry(xBegin,xEnd,yBegin,yEnd)
  {
  }

  /**
  * Get the geometry interface
  */
  virtual const MiSurfaceGeometryRectilinear& getGeometry() const
  {
    return m_geometry;
  }

protected:
  virtual std::ostream& toStream(std::ostream& s) const;

  MbSurfaceGeometryRectilinear<_CoordT> m_geometry;

};

//-----------------------------------------------------------------------------
template <typename _CoordT, typename _ScalarT, typename _Vec3T>
inline std::ostream& 
MbSurfaceMeshRectilinear<_CoordT,_ScalarT,_Vec3T>::toStream(std::ostream& s) const
{
  MiSurfaceMeshRectilinear::toStream(s);
  MbMeshIj<_ScalarT,_Vec3T>::toStream(s);
  return s;
}

#ifdef _WIN32
#  pragma warning( pop )
#endif

#endif


