#ifndef  _MixSurfaceMesh_h
#define  _MixSurfaceMesh_h


#include <cell/MbTriangleCell.h>

#include "QuadraticSurfaceMesh.h"

#include <Inventor/STL/vector>

//-----------------------------------------------------------------------------
class MixTopology : public QuadraticTopology
{
public:
  MixTopology() 
    : m_cell0(0,1,2) , m_cell1(0,2,6)
  {
  }

  virtual const MiSurfaceCell* getCell(size_t id) const
  {
    switch (id)
    {
    case 0: return &m_cell0;
    case 1: return &m_cell1;
    default: return QuadraticTopology::getCell(id);
    }
  }

private:
  MbTriangleCell m_cell0;
  MbTriangleCell m_cell1;
};


//-----------------------------------------------------------------------------
class MixSurfaceMesh : public QuadraticSurfaceMesh
{
public:
  MixSurfaceMesh() {}

  virtual const MiSurfaceTopologyExplicitI& getTopology() const 
  {
    return m_topology;
  }

private:
  MixTopology m_topology;
};

#endif 


