#ifndef  _QuadraticSurfaceMesh_h
#define  _QuadraticSurfaceMesh_h

#include <MeshVizXLM/mesh/MiSurfaceMeshUnstructured.h>
#include <MeshVizXLM/mesh/data/MiDataSetI.h>
#include <MeshVizXLM/MxTimeStamp.h>

#include <cell/QuadraticTriangle6Cell.h>
#include <cell/QuadraticQuadrangle8Cell.h>
#include <cell/QuadraticQuadrangle9Cell.h>

#include <Inventor/STL/vector>

class QuadraticScalardSetI : public MiScalardSetI
{
public:
  QuadraticScalardSetI()
  {
    m_data[0] = 0;
    m_data[1] = 0.1;
    m_data[2] = 2;
    m_data[3] = 3.5;
    m_data[4] = 4;
    m_data[5] = 4.5;
  }

  virtual double getMin() const 
  {
    return 0;
  }

  virtual double getMax() const 
  {
    return 4.5;
  }

  virtual double get(size_t id) const 
  {
    return m_data[id];
  }

  DataBinding getBinding() const
  {
    return PER_NODE;
  }


  virtual size_t getTimeStamp() const 
  {
    return 1;
  }

  virtual std::string getName() const
  {
    return "QuadraticScalardSetI";
  }

private:
  double m_data[6];
};

//-----------------------------------------------------------------------------
class QuadraticGeometry : public MiGeometryI
{
public:
  QuadraticGeometry()
  {
    m_coords.push_back(MbVec3d( 0, 0, 0 )); // node 0
    m_coords.push_back(MbVec3d(+2, 0, 0 )); // node 1
    m_coords.push_back(MbVec3d(+1,+2, 0 )); // node 2

    m_coords.push_back(MbVec3d(0.8,0.1, 0.2)); // node 3 
    m_coords.push_back(MbVec3d(1.7,1.7, 0.1)); // node 4
    m_coords.push_back(MbVec3d(0.3,0.9, -0.3)); // node 5

    m_coords.push_back(MbVec3d(-2,0.2, -0.5 )); // node 6
    m_coords.push_back(MbVec3d(-1,1.8, 0.1)); // node 7
    m_coords.push_back(MbVec3d(-1,0.05,-0.2 )); // node 8

    m_coords.push_back(MbVec3d(-2.0,-2.0,-0.2 )); // node 9
    m_coords.push_back(MbVec3d( 0.0,-2.0,-0.3 )); // node 10
    m_coords.push_back(MbVec3d(-2.2,-1.0,-0.1 )); // node 11
    m_coords.push_back(MbVec3d(-1.0,-1.8,-0.25)); // node 12
    m_coords.push_back(MbVec3d(-0.2,-1.0,-0.25)); // node 13

    m_coords.push_back(MbVec3d( 2.0,-2.0, 0.20)); // node 14

    m_coords.push_back(MbVec3d( 1.0,-1.8, -0.05)); // node 15
    m_coords.push_back(MbVec3d( 1.8,-1.2, 0.1)); // node 16  
    m_coords.push_back(MbVec3d( 1.1,-1, 0.2)); // node 17 

    m_timeStamp = MxTimeStamp::getTimeStamp();
  }

  const std::vector<MbVec3d>& getCoords() const
  {
    return m_coords;
  }

  virtual MbVec3d getCoord(size_t i) const 
  {
    return m_coords[i];
  }

  virtual size_t getTimeStamp() const 
  {
    return m_timeStamp;
  }

  void clearZ()
  {
    for (size_t i=0; i<m_coords.size(); ++i)
    {
      MbVec3d coord = m_coords[i];
      coord[2] = 0;
      m_coords[i] = coord;
    }
  }
private:
  std::vector<MbVec3d> m_coords;
  size_t m_timeStamp;
};

//-----------------------------------------------------------------------------
class QuadraticTopology : public MiSurfaceTopologyExplicitI
{
public:
  QuadraticTopology() 
    : m_cell0(0,1,2,3,4,5) , m_cell1(0,2,6,5,7,8) , 
    m_cell2(9,10,0,6, 12,13,8,11), m_cell3(1,0,10,14, 3,13,15,16,17)
  {
  }

  virtual bool hasDeadCells() const { return true; }
  virtual bool isDead(size_t /*i*/) const { return false; }

  virtual const MiSurfaceCell* getCell(size_t id) const
  {
    switch (id)
    {
    case 0: return &m_cell0;
    case 1: return &m_cell1;
    case 2: return &m_cell2;
    case 3: return &m_cell3;
    default: return NULL;
    }
  }

  virtual size_t getEndNodeId() const
  {
    return 18;
  }

  virtual size_t getNumCells() const
  {
    return 4;
  }

  virtual size_t getTimeStamp() const 
  {
    return 1;
  }

private:
  QuadraticTriangle6Cell m_cell0;
  QuadraticTriangle6Cell m_cell1;
  QuadraticQuadrangle8Cell m_cell2;
  QuadraticQuadrangle9Cell m_cell3;
};


//-----------------------------------------------------------------------------
class QuadraticSurfaceMesh : public MiSurfaceMeshUnstructured
{
public:
  QuadraticSurfaceMesh() {}

  virtual const MiSurfaceTopologyExplicitI& getTopology() const 
  {
    return m_topology;
  }

  virtual const MiGeometryI& getGeometry() const 
  {
    return m_geometry;
  }

  const std::vector<MbVec3d>& getCoords() const
  {
    return m_geometry.getCoords();
  }


private:
  QuadraticGeometry m_geometry;
  QuadraticTopology m_topology;
};


class ScalarSet : public MbScalardSetI
{
public:
  ScalarSet(const MiSurfaceMeshUnstructured& mesh) 
    : m_geometry(mesh.getGeometry())
  {
    m_vmin = 1E30;
    m_vmax = -1E30;
    for (size_t i=mesh.getTopology().getBeginNodeId(); i!=mesh.getTopology().getEndNodeId(); ++i)
    {
      double v = get(i);
      if (v < m_vmin) m_vmin = v;
      if (v > m_vmax) m_vmax = v;
    }
  }
  double get(size_t i) const 
  { 
    MbVec3d coord = m_geometry.getCoord(i);
    return  coord[0]*coord[0] + coord[1]*coord[1];
  }

  double getMin () const { return 0; }
  double getMax () const { return 20; }
  size_t  getTimeStamp () const  { return 1; }
  std::string getName () const  { return "testData"; }
  DataBinding  getBinding () const { return PER_NODE; }

private:
  const MiGeometryI& m_geometry;
  double m_vmin,m_vmax;
};

class ScalarSetPerCell : public MiScalardSetI
{
public:
  ScalarSetPerCell(const MiSurfaceMeshUnstructured& mesh) 
    : m_vmax((double)mesh.getTopology().getNumCells())
  {
  }
  double get(size_t i) const 
  { 
    return (double) i;
  }

  double getMin () const { return 0; }
  double getMax () const { return m_vmax; }
  size_t  getTimeStamp () const  { return 1; }
  std::string getName () const  { return "CellId"; }
  DataBinding  getBinding () const { return PER_CELL; }

private:
  double m_vmax;
};

#endif 


