/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MBHEXAHEDRONMESHIJK_H
#define  _MBHEXAHEDRONMESHIJK_H

#ifdef _WIN32
#  pragma warning( push )
#  pragma warning(disable:4250)
#endif

#include <MeshVizXLM/mesh/MiVolumeMeshHexahedronIjk.h>
#include <mesh/MbMesh.h>
#include <mesh/MbMeshIjk.h>
#include <topology/MbHexahedronTopologyExplicitIjk.h>
#include <MeshVizXLM/MbVec3.h>

#include <Inventor/STL/vector>
#include <Inventor/STL/iostream>

/**
 * @DTEXT  Defines a meshIjk of hexahedrons as a pillar mesh.
 * 
 * @ingroup MeshVizXLM_Implement_Mesh
 * 
 * @DESCRIPTION
 *
 * Hexahedrons are defined as follows:
 *
 * \verbatim
                          S
                          |
                          |

                         n3----------n2
                         /|          /|
                       /  |        /  |
                     /    |      /    |
                   n7---------n6      |
                    |     |    |      |
                    |    n0----|-----n1    --- R
                    |    /     |     /
                    |  /       |   /
                    |/         | /
                   n4---------n5

                 /
               /
             T
   \endverbatim
 * 
 */
template <typename _CoordT=MbVec3d, typename _ScalarT=double, typename _Vec3T=MbVec3d, MiMeshIjk::StorageLayout layout = MiMeshIjk::LAYOUT_KJI>
class MbHexahedronMeshIjk : public MiVolumeMeshHexahedronIjk, public MbMesh<_CoordT,_ScalarT,_Vec3T>,
                            public MbMeshIjk<_ScalarT,_Vec3T,layout>
{

public:
  /**
  * Constructor of an empty mesh. 
  */
  MbHexahedronMeshIjk(size_t numCellI, size_t numCellJ, size_t numCellK) :
  m_topology(numCellI,numCellJ,numCellK)
  { 
  }
  /**
   * Constructor of a volume mesh. 
   */
  template <typename _Vec3Iter>
  MbHexahedronMeshIjk(size_t numCellI, size_t numCellJ, size_t numCellK,
                      _Vec3Iter beginCoord, _Vec3Iter endCoord);

  const MiHexahedronTopologyExplicitIjk& getTopology() const 
  {
    return m_topology;
  }

  /**
  * Defines hexahedron cell indices
  */
  template <typename _NodeIdIter>
  void setCellNodeIndices(size_t i, size_t j, size_t k,
                          _NodeIdIter beginId, _NodeIdIter endId)
  {
    m_topology.setCellNodeIndices(i,j,k,beginId,endId);
  }

  /**
  * Defines dead cells
  */
  void setDeadCell(size_t i, size_t j, size_t k, bool isDead=true)
  {
    m_topology.setDeadFlag(i,j,k,isDead);
  }

  void touch()
  {
    m_topology.touch();
    this->m_geometry.touch();
  }

protected:
  virtual std::ostream& toStream(std::ostream& s) const;

  MbHexahedronTopologyExplicitIjk<layout> m_topology;

};


//-----------------------------------------------------------------------------
template <typename _CoordT, typename _ScalarT, typename _Vec3T, MiMeshIjk::StorageLayout layout>
template <typename _Vec3Iter>
inline MbHexahedronMeshIjk<_CoordT,_ScalarT,_Vec3T,layout>::MbHexahedronMeshIjk(
  size_t numCellI, size_t numCellJ, size_t numCellK,
  _Vec3Iter beginCoord, _Vec3Iter endCoord
  ) :
 MbMesh<_CoordT,_ScalarT,_Vec3T>(beginCoord,endCoord),
 m_topology(numCellI,numCellJ,numCellK)
{
}

//-----------------------------------------------------------------------------
template <typename _CoordT, typename _ScalarT, typename _Vec3T, MiMeshIjk::StorageLayout layout>
inline std::ostream& 
MbHexahedronMeshIjk<_CoordT,_ScalarT,_Vec3T,layout>::toStream(std::ostream& s) const
{
  s << "# MbHexahedronMeshIjk" << std::endl;
  // output the inherited geometry and dataset
  MiVolumeMeshHexahedronIjk::toStream(s);
  MbMesh<_CoordT,_ScalarT,_Vec3T>::toStream(s);
  MbMeshIjk<_ScalarT,_Vec3T,layout>::toStream(s);
  return s;

}

#ifdef _WIN32
#  pragma warning( pop )
#endif

#endif







