/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef _MBMESHSTRUCTUREDIJK_H
#define _MBMESHSTRUCTUREDIJK_H

#ifdef _WIN32
#  pragma warning( push )
#  pragma warning(disable:4250)
#  pragma warning(disable:4251)
#endif

#include <MeshVizXLM/mesh/MiMeshIjk.h>
#include <mesh/MbMeshIjk.h>
#include <topology/MbTopologyIjk.h>

/**
 * @DTEXT class defining a structured volume mesh.
 * 
 * @ingroup MeshVizXLM_Implement_Mesh
 * 
 * @DESCRIPTION

 * 
 */

template <typename _ScalarT=double, typename _Vec3T=MbVec3d, MiMeshIjk::StorageLayout _Layout = MiMeshIjk::LAYOUT_KJI>
class MbMeshStructuredIjk : public MbMeshIjk<_ScalarT,_Vec3T,_Layout>
{
public:
  /** Constructor */
  MbMeshStructuredIjk(size_t numCellI, size_t numCellJ, size_t numCellK) 
    : m_topology(numCellI,numCellJ,numCellK) 
  {
  }

  MbMeshStructuredIjk(const MbTopologyIjk<_Layout>& topology)
    : m_topology(topology)
  {
  }

  virtual const MiTopologyIjk& getTopology() const
  {
    return m_topology;
  }

  /**
  * Defines dead cells
  */
  void setDeadCell(size_t i, size_t j, size_t k, bool isDead=true)
  {
    m_topology.setDeadFlag(i,j,k,isDead);
  }

protected:
  virtual std::ostream& toStream(std::ostream& s) const;

  MbTopologyIjk<_Layout>     m_topology;
};

//-----------------------------------------------------------------------------
template <typename _ScalarT, typename _Vec3T, MiMeshIjk::StorageLayout _Layout>
inline std::ostream& 
MbMeshStructuredIjk<_ScalarT,_Vec3T,_Layout>::toStream(std::ostream& s) const
{
  MbMeshIjk<_ScalarT,_Vec3T,_Layout>::toStream(s);
  return s;
}


#ifdef _WIN32
#  pragma warning( pop )
#endif

#endif


