/*=======================================================================
** VSG_COPYRIGHT_TAG
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MBVERTEXHEXAHEDRONMESHIJK_H
#define  _MBVERTEXHEXAHEDRONMESHIJK_H

#ifdef _WIN32
#  pragma warning( push )
#  pragma warning(disable:4250)
#endif

#include <MeshVizXLM/mesh/MiVolumeMeshVertexHexahedronIjk.h>
#include <MeshVizXLM/mesh/MiVolumeMeshHexahedronIjk.h>
#include <mesh/volumes/MbMeshStructuredIjk.h>
#include <mesh/volumes/MbHexahedronMeshIjk.h>
#include <geometry/MbGeometryHexahedronIjk.h>
#include <MeshVizXLM/MbVec3.h>

#include <Inventor/STL/iostream>

/**
 * @DTEXT  Defines a non indexed meshIjk of hexahedrons
 * 
 * @ingroup MeshVizXLM_Implement_Mesh
 * 
 * @DESCRIPTION
 *
 * This mesh is built from a indexed hexahedronIjk mesh. It behaves as a wrapper.
 * Hexahedrons are defined as follows:
 *
 * <PRE>
 *                        S
 *                        |
 *                        |
 *
 *                       n3----------n2       
 *                       /|          /|   
 *                     /  |        /  |   
 *                   /    |      /    |      
 *                 n7---------n6      |  
 *                  |     |    |      |    
 *                  |    n0----|-----n1    --- R               
 *                  |    /     |     /                    
 *                  |  /       |   /                      
 *                  |/         | /                        
 *                 n4---------n5                          
 *             
 *               /
 *             /
 *           T
 * </PRE>
 * 
 */
template <typename _CoordT=MbVec3d, typename _ScalarT=double, typename _Vec3T=MbVec3d, MiMeshIjk::StorageLayout _LAYOUT = MiMeshIjk::LAYOUT_KJI>
class MbVertexHexahedronMeshIjk : public MiVolumeMeshVertexHexahedronIjk,
                                  public MbMeshStructuredIjk<_ScalarT,_Vec3T,_LAYOUT>
{

public:
  MbVertexHexahedronMeshIjk(const MbHexahedronMeshIjk<_CoordT,_ScalarT,_Vec3T,_LAYOUT>& indexedMesh) :
    MbMeshStructuredIjk<_ScalarT, _Vec3T, _LAYOUT>(dynamic_cast< const MbTopologyIjk<_LAYOUT>& >(indexedMesh.getTopology())), m_geometry(indexedMesh)
  { 
    for (size_t i = 0; i < indexedMesh.getNumScalarSetsIjk(); ++i)
      if (indexedMesh.getScalarSetIjk(i)->getBinding() == MiDataSet::PER_CELL)
        this->addScalarSetIjk(indexedMesh.getScalarSetIjk(i));
    for (size_t i = 0; i < indexedMesh.getNumVec3SetsIjk(); ++i)
      if (indexedMesh.getVec3SetIjk(i)->getBinding() == MiDataSet::PER_CELL)
        this->addVec3SetIjk(indexedMesh.getVec3SetIjk(i));
  }

  const MiGeometryHexahedronIjk& getGeometry() const
  {
    return m_geometry;
  }

  void touch()
  {
    m_geometry.touch();
  }

protected:
  virtual std::ostream& toStream(std::ostream& s) const;

  MbGeometryHexahedronIjk<_LAYOUT> m_geometry;

};

//-----------------------------------------------------------------------------
template <typename _CoordT, typename _ScalarT, typename _Vec3T, MiMeshIjk::StorageLayout _LAYOUT>
inline std::ostream& 
  MbVertexHexahedronMeshIjk<_CoordT,_ScalarT,_Vec3T,_LAYOUT>::toStream(std::ostream& s) const
{
  MiVolumeMeshVertexHexahedronIjk::toStream(s);
  MbMeshIjk<_ScalarT,_Vec3T,_LAYOUT>::toStream(s);
  return s;
}

#ifdef _WIN32
#  pragma warning( pop )
#endif

#endif







