/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef _MBVOLUMEMESHCURVILINEAR_H
#define _MBVOLUMEMESHCURVILINEAR_H

#ifdef _WIN32
#  pragma warning( push )
#  pragma warning(disable:4250)
#  pragma warning(disable:4251)
#endif

#include <MeshVizXLM/mesh/MiVolumeMeshCurvilinear.h>
#include <mesh/volumes/MbMeshStructuredIjk.h>

#include <geometry/MbGeometryIjk.h>

/**
 * @DTEXT class defining a Curvilinear volume mesh.
 * 
 * @ingroup MeshVizXLM_Implement_Mesh
 * 
 * @DESCRIPTION

 * 
 */

template <typename _CoordT=MbVec3d, typename _ScalarT=double, typename _Vec3T=MbVec3d, MiMeshIjk::StorageLayout _Layout = MiMeshIjk::LAYOUT_KJI>
class MbVolumeMeshCurvilinear : virtual public MiVolumeMeshCurvilinear, public MbMeshStructuredIjk<_ScalarT,_Vec3T,_Layout>
{
public:

  /** Constructor */
  MbVolumeMeshCurvilinear(size_t numCellI, size_t numCellJ, size_t numCellK) 
    : MbMeshStructuredIjk<_ScalarT,_Vec3T,_Layout>(numCellI,numCellJ,numCellK),
      m_geometry(numCellI+1,numCellJ+1,numCellK+1)
  {
  }


  /**
  * Set coordinate (i,j,k)
  */
  virtual void setCoord(size_t i, size_t j, size_t k, const _CoordT& val )
  {
    m_geometry.setCoord(i,j,k,val);
  }
  
  /**
  * Get the geometry interface
  */
  virtual const MiGeometryIjk& getGeometry() const
  {
    return m_geometry;
  }

  void touch()
  {
    this->m_topology.touch();
    this->m_geometry.touch();
  }


protected:
  virtual std::ostream& toStream(std::ostream& s) const;

  MbGeometryIjk<_CoordT,_Layout> m_geometry;

};

//-----------------------------------------------------------------------------
template <typename _CoordT, typename _ScalarT, typename _Vec3T, MiMeshIjk::StorageLayout _Layout>
inline std::ostream& 
MbVolumeMeshCurvilinear<_CoordT,_ScalarT,_Vec3T,_Layout>::toStream(std::ostream& s) const
{
  MiVolumeMeshCurvilinear::toStream(s);
  MbMeshStructuredIjk<_ScalarT,_Vec3T,_Layout>::toStream(s);
  return s;
}


#ifdef _WIN32
#  pragma warning( pop )
#endif

#endif


