/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _MbVolumeMeshPolyhedron_H
#define  _MbVolumeMeshPolyhedron_H

#ifdef _WIN32
#  pragma warning( push )
#  pragma warning(disable:4250)
#endif

#include <MeshVizXLM/mesh/MiVolumeMeshUnstructured.h>
#include <MeshVizXLM/mesh/topology/MiVolumeTopologyExplicitI.h>

#include <mesh/volumes/MbVolumeMeshUnstructured.h>
#include <topology/MbPolyhedronCellsSet.h>
#include <MeshVizXLM/MbVec3.h>

#include <Inventor/STL/vector>
#include <Inventor/STL/iostream>

/**
 * @DTEXT  Defines a mesh of Polyhedrons.
 * 
 * @ingroup MeshVizXLM_Implement_Mesh
 * 
 * @DESCRIPTION

 * 
 */
template <typename _CoordT=MbVec3d, typename _ScalarT=double, typename _Vec3T=MbVec3d>
class MbVolumeMeshPolyhedron : public MbVolumeMeshUnstructured<_CoordT,_ScalarT,_Vec3T>
{

public:

  /**
  * Constructor of an empty mesh. 
  */
  MbVolumeMeshPolyhedron() {}

  /**
  * Constructor of a volume mesh. 
  */
  template <typename _Vec3Iter, typename _FacetNodeIter, typename _FacetRefIter>
  MbVolumeMeshPolyhedron(_Vec3Iter beginCoord, _Vec3Iter endCoord, 
                         _FacetNodeIter beginFacetNode, _FacetNodeIter endFacetNode,
                         _FacetRefIter beginFacetRef, _FacetRefIter endFacetRef,
                         const std::vector<size_t>* cellFacets, size_t numCells);

  /**
  * Constructor of a volume mesh. 
  */
  template <typename _Vec3Iter, typename _FacetNodeIter, typename _NumNodeIter, typename _NumFacetIter>
    MbVolumeMeshPolyhedron(_Vec3Iter beginCoord, _Vec3Iter endCoord, 
                           _FacetNodeIter beginFacetNode, _FacetNodeIter endFacetNode,
                           _NumNodeIter beginNumNode, _NumNodeIter endNumNode,
                           _NumFacetIter beginNumFacet, _NumFacetIter endNumFacet);

  /**
  * Sets a new topology
  */
  template <typename _FacetNodeIter, typename _NumNodeIter, typename _NumFacetIter>
  void setTopology(_FacetNodeIter beginFacetNode, _FacetNodeIter endFacetNode,
                   _NumNodeIter beginNumNode, _NumNodeIter endNumNode,
                   _NumFacetIter beginNumFacet, _NumFacetIter endNumFacet)
  {
    m_topology.assign(beginFacetNode,endFacetNode,beginNumNode,endNumNode,beginNumFacet,endNumFacet);
  }


  virtual const MbPolyhedronCellsSet& getTopology() const;

  /**
  * Defines dead cells
  */
  template <typename _BoolIter>
  void setDeadCells(_BoolIter beginId, _BoolIter endId)
  {
    m_topology.assignDeadFlags(beginId,endId);
  }

protected:
  virtual std::ostream& toStream(std::ostream& s) const;

  MbPolyhedronCellsSet m_topology;
};

//-----------------------------------------------------------------------------
template <typename _CoordT, typename _ScalarT, typename _Vec3T>
template <typename _Vec3Iter, typename _FacetNodeIter, typename _FacetRefIter>
inline MbVolumeMeshPolyhedron<_CoordT,_ScalarT,_Vec3T>::MbVolumeMeshPolyhedron(
  _Vec3Iter beginCoord, _Vec3Iter endCoord, 
  _FacetNodeIter beginFacetNode, _FacetNodeIter endFacetNode,
  _FacetRefIter beginFacetRef, _FacetRefIter endFacetRef,
  const std::vector<size_t>* cellFacets, size_t numCells
  ) :
MbVolumeMeshUnstructured<>(beginCoord,endCoord)
{
  m_topology.assign(beginFacetNode,endFacetNode,beginFacetRef,endFacetRef,cellFacets,numCells);
}

//-----------------------------------------------------------------------------
template <typename _CoordT, typename _ScalarT, typename _Vec3T>
  template <typename _Vec3Iter, typename _FacetNodeIter, typename _NumNodeIter, typename _NumFacetIter>
inline MbVolumeMeshPolyhedron<_CoordT,_ScalarT,_Vec3T>::MbVolumeMeshPolyhedron(
  _Vec3Iter beginCoord, _Vec3Iter endCoord, 
  _FacetNodeIter beginFacetNode, _FacetNodeIter endFacetNode,
  _NumNodeIter beginNumNode, _NumNodeIter endNumNode,
  _NumFacetIter beginNumFacet, _NumFacetIter endNumFacet
  ) :
   MbVolumeMeshUnstructured<_CoordT,_ScalarT,_Vec3T>(beginCoord,endCoord)
{
  setTopology(beginFacetNode,endFacetNode,beginNumNode,endNumNode,beginNumFacet,endNumFacet);
}


//-----------------------------------------------------------------------------
template <typename _CoordT, typename _ScalarT, typename _Vec3T>
inline const MbPolyhedronCellsSet&
MbVolumeMeshPolyhedron<_CoordT,_ScalarT,_Vec3T>::getTopology() const
{
  return m_topology;
}

//-----------------------------------------------------------------------------
template <typename _CoordT, typename _ScalarT, typename _Vec3T>
inline std::ostream& 
MbVolumeMeshPolyhedron<_CoordT,_ScalarT,_Vec3T>::toStream(std::ostream& s) const
{
  s << "# MbVolumeMeshPolyhedron" << std::endl;
  // output the inherited geometry and dataset
  MbVolumeMeshUnstructured<_CoordT,_ScalarT,_Vec3T>::toStream(s);

  return s;
}

#ifdef _WIN32
#  pragma warning( pop )
#endif

#endif







