/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef _MBVOLUMEMESHRECTILINEAR_H
#define _MBVOLUMEMESHRECTILINEAR_H

#ifdef _WIN32
#  pragma warning( push )
#  pragma warning(disable:4250)
#  pragma warning(disable:4251)
#endif

#include <MeshVizXLM/mesh/MiVolumeMeshRectilinear.h>
#include <mesh/volumes/MbMeshStructuredIjk.h>

#include <geometry/MbVolumeGeometryRectilinear.h>

/**
 * @DTEXT class defining a Rectilinear volume mesh.
 * 
 * @ingroup MeshVizXLM_Implement_Mesh
 * 
 * @DESCRIPTION

 * 
 */

template <typename _CoordT=double, typename _ScalarT=double, typename _Vec3T=MbVec3d, MiMeshIjk::StorageLayout _Layout = MiMeshIjk::LAYOUT_KJI>
class MbVolumeMeshRectilinear : virtual public MiVolumeMeshRectilinear, public MbMeshStructuredIjk<_ScalarT,_Vec3T,_Layout>
{
public:
  /** Constructor */
  template <typename _NodeIdIter>
  MbVolumeMeshRectilinear(size_t numCellI, size_t numCellJ, size_t numCellK, 
    _NodeIdIter xBegin,_NodeIdIter xEnd, 
    _NodeIdIter yBegin,_NodeIdIter yEnd,
    _NodeIdIter zBegin,_NodeIdIter zEnd) 
    : MbMeshStructuredIjk<_ScalarT,_Vec3T,_Layout>(numCellI,numCellJ,numCellK),
      m_geometry(xBegin,xEnd,yBegin,yEnd,zBegin,zEnd)
  {
  }

  /** Gets the geometry interface */
  virtual const MiVolumeGeometryRectilinear& getGeometry() const
  {
    return m_geometry;
  }

  void touch()
  {
    this->m_topology.touch();
    this->m_geometry.touch();
  }

protected:
  virtual std::ostream& toStream(std::ostream& s) const;

  MbVolumeGeometryRectilinear<_CoordT> m_geometry;

};

//-----------------------------------------------------------------------------
template <typename _CoordT, typename _ScalarT, typename _Vec3T, MiMeshIjk::StorageLayout _Layout>
inline std::ostream& 
MbVolumeMeshRectilinear<_CoordT,_ScalarT,_Vec3T,_Layout>::toStream(std::ostream& s) const
{
  MiVolumeMeshRectilinear::toStream(s);
  MbMeshStructuredIjk<_ScalarT,_Vec3T,_Layout>::toStream(s);
  return s;
}


#ifdef _WIN32
#  pragma warning( pop )
#endif

#endif


