#ifndef _PEBIMESH_H_
#define _PEBIMESH_H_

#ifdef _WIN32
#  pragma warning( push )
#  pragma warning(disable:4355)
#endif

#include <MeshVizXLM/mesh/MiVolumeMeshUnstructured.h>
#include <MeshVizXLM/MbVec3.h>
#include <topology/PEBITopology.h>
#include <geometry/PEBIGeometry.h>
#include <data/PEBIScalarSet.h>

class PEBIMesh : public MiVolumeMeshUnstructured 
{
public:
  PEBIMesh( size_t numLayer, float elevation )
    : m_geometry( numLayer, elevation )
    , m_topology( numLayer - 1 )
    , m_property( this )
  {
  }
  
  /**
  * Returns the topology of this mesh.
  */
  const MiVolumeTopologyExplicitI& getTopology() const 
  {
    return m_topology; 
  }

  /**
  * Returns the unstructured geometry of this mesh. 
  */
  const PEBIGeometry& getGeometry() const
  { 
    return m_geometry; 
  }

  /* 
  * Computes bounding box center 
  */
  MbVec3f getCenter() const
  {
    return MbVec3f(m_geometry.getMin() + m_geometry.getMax())/2.0f;
  }

  MbVec3f getBBSize() const
  {
    return MbVec3f(m_geometry.getMax() - m_geometry.getMin());
  }

  const PEBIScalarSet& getScalarSet() const
  {
    return m_property;
  }

  void touch()
  {
    m_topology.touch();
    m_geometry.touch();
  }

private:
  friend class PEBIReader;

  PEBIGeometry m_geometry;
  PEBITopology m_topology;  
  PEBIScalarSet m_property;
};

#ifdef _WIN32
#  pragma warning( pop )
#endif

#endif


