#ifndef  _WheelHexa27Mesh_h
#define  _WheelHexa27Mesh_h

#include <MeshVizXLM/mesh/MiVolumeMeshUnstructured.h>
#include <MeshVizXLM/mesh/data/MiDataSetI.h>

#include <cell/WheelHexahedron27Cell.h>
#include <geometry/WheelGeometry.h>
#include <topology/WheelHexa27Topology.h>

#include <Inventor/SbBox.h>

#include <Inventor/STL/vector>

static double s_radiusMin = 3;
static double s_radiusMax = 8;
static double s_alpha0 = 0;
static double s_alpha1 = 3.1415927 *2;

static double s_beta0 = 40.0 * 3.1415927/180.0;
static double s_beta1 = -s_beta0;

//-----------------------------------------------------------------------------
class WheelHexa27Mesh : public MiVolumeMeshUnstructured
{
public:
  WheelHexa27Mesh(size_t numCellR, size_t numCellA, size_t numCellZ) :
    m_geometry(numCellR,numCellA,numCellZ),
    m_topology(numCellR,numCellA,numCellZ)
  {
    m_geometry.setGeometry(s_radiusMin,s_radiusMax, s_alpha0,s_alpha1, s_beta0,s_beta1 );
  }

  virtual const MiVolumeTopologyExplicitI& getTopology() const 
  {
    return m_topology;
  }

  virtual const MiGeometryI& getGeometry() const 
  {
    return m_geometry;
  }

  void touch()
  {
    m_topology.touch();
    m_geometry.touch();
  }

  //const std::vector<MbVec3d>& getCoords() const
  //{
  //  return m_geometry.getCoords();
  //}


private:
  WheelGeometry m_geometry;
  WheelHexa27Topology m_topology;
};

#endif 


