/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2019 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Martial Bonaventure (Mar 2010)
**=======================================================================*/

#ifndef _MyLineMeshCurvilinear_H
#define _MyLineMeshCurvilinear_H

/**
* @DTEXT Curvilinear line mesh template.
* 
* @ingroup MeshVizXLM_Mesh_Templates
* 
* @DESCRIPTION
*        Header file to be completed including all required classes to define 
*        a curvilinear line mesh with its associated scalar and vector sets.
*
*        Intended to help implement simple mesh. Just fill up the empty
*        methods of the following classes (search for PUT_YOUR_CODE_HERE): 
*         - MyTopologyI :  topology template.
*         - MyGeometryI :  geometry template.
*         - MyScalarSetI :  scalar set template.
*         - MyVectorSetI :  vector set template.
*
*        Hint: some should inherit both from MeshViz interfaces and the user's application data classes.
*
*        @note Nonmandatory methods are marked as optional.
*
*        For advanced implementations, refer to the MiLineMeshCurvilinear interface.
* 
*/

#include <MeshVizXLM/mesh/topology/MiTopologyI.h>
/**
* Class defining the topology of the mesh.
*/
class MyTopologyI : public MiTopologyI
{
public:
  /**
  * Returns the number of cells.
  */
  size_t getNumCells() const
  {
     // PUT_YOUR_CODE_HERE.
  }

  /** 
  * Returns true if the topology contains dead cells.
  * When false, the cells traversal can be optimized by not testing 
  * the isDead() method of each individual cells.
  */ 
  bool hasDeadCells() const
  {
    // PUT_YOUR_CODE_HERE (Optional).
    // Required only if the topology has dead cells, remove this method otherwise to use 
    // the default implementation that always returns false.
  }

 /** 
  * Returns true if the cell of index i should be ignored.
  * This value is ignored if the hasDeadCell() method returns false.
  * @param i the index of the cell to check
  */ 
  bool isDead(size_t i) const
  {
    // PUT_YOUR_CODE_HERE (Optional).
    // Required only if the topology has dead cells, remove this method otherwise to use 
    // the default implementation that always returns false.
  }

  /**
  * Returns a time stamp on this topology. 
  */
  size_t getTimeStamp() const
  {
    // PUT_YOUR_CODE_HERE (see MxTimeStamp).
    // When the content of the topology changes, the time stamp must also change.
    // The time stamp allows MeshViz to be aware of any change to this topology.
  }


};

#include <MeshVizXLM/mesh/geometry/MiGeometryI.h>
/**
* Class defining the geometry of the mesh.
*/
class MyGeometryI : public MiGeometryI //, public YourGeometry
// Advised to inherit from the class containing your application geometry.
{
public:
  /**
  * Returns the coordinate i-th of this geometry.
  */
  virtual MbVec3d getCoord(size_t i) const
  {
    // PUT_YOUR_CODE_HERE.
  }

  /**
  * Returns a time stamp on this geometry.
  */
  size_t getTimeStamp() const
  {
    // PUT_YOUR_CODE_HERE (see MxTimeStamp).
    // When the content of the geometry changes, the time stamp must also change.
    // The time stamp allows MeshViz to be aware of any change to this geometry.
  }
};

#include <MeshVizXLM/mesh/MiLineMeshCurvilinear.h>
/**
* Class defining a curvilinear line mesh.
*/
class MyLineMeshCurvilinear : public MiLineMeshCurvilinear
{

public:
  /**
  * Returns the geometry of this mesh. 
  */
  const MiGeometryI& getGeometry() const
  {
    return m_geometry;
  }

  /**
  * Returns the topology of this mesh. 
  */
  const MiTopologyI& getTopology() const
  {
    return m_topology;
  }


private:
  MyGeometryI m_geometry;
  MyTopologyI m_topology;

};

#include <MeshVizXLM/mesh/data/MiDataSetI.h>
/**
* Class defining a scalar set associated to the mesh.
*/
class MyScalarSetI : public MiScalardSetI //, public YouData
// Advised to inherit from the class containing your application data.
{
public:

  /**
  * Returns the i-th value of this set.
  */
  double get(size_t i) const
  {
    // PUT_YOUR_CODE_HERE.
  }

  /**
  * Returns a time stamp on this scalar set.
  */
  size_t getTimeStamp() const
  {
    // PUT_YOUR_CODE_HERE (see MxTimeStamp).
    // When the content of the scalar set changes, the time stamp must also change.
    // The time stamp allows MeshViz to be aware of any change to this scalar set.
  }

  /**
  * Returns the name of this scalar set.
  */
  std::string getName() const
  {
    // PUT_YOUR_CODE_HERE.
  }

  /**
  * Returns the data binding of this scalar set.
  */
  DataBinding  getBinding() const
  {
    // PUT_YOUR_CODE_HERE (see MiDataSet::DataBinding).
  }

};

#include <MeshVizXLM/mesh/data/MiDataSetI.h>
/**
* Class defining a vector set associated to the mesh.
*/
class MyVectorSetI : public MiVec3dSetI //, public YourData
// Advised to inherit from the class containing your application data.
{
public:

  /**
  * Returns the i-th vector of this set.
  */
  MbVec3d get(size_t i) const
  {
    // PUT_YOUR_CODE_HERE.
  }

  /**
  * Returns a time stamp on this vector set.
  */
  size_t getTimeStamp() const
  {
    // PUT_YOUR_CODE_HERE (see MxTimeStamp).
    // When the content of the vector set changes, the time stamp must also change.
    // The time stamp allows MeshViz to be aware of any change to this vector set.
  }

  /**
  * Returns the name of this vector set.
  */
  std::string getName() const
  {
    // PUT_YOUR_CODE_HERE.
  }

  /**
  * Returns the data binding of this vector set.
  */
  DataBinding  getBinding() const
  {
    // PUT_YOUR_CODE_HERE (see MiDataSet::DataBinding).
  }

};

#endif 







