/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2019 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Martial Bonaventure (Mar 2010)
**=======================================================================*/

#ifndef _MySurfaceMeshRectilinear_H
#define _MySurfaceMeshRectilinear_H

/**
* @DTEXT Rectilinear surface mesh template.
* 
* @ingroup MeshVizXLM_Mesh_Templates
* 
* @DESCRIPTION
*        Header file to be completed including all required classes to define 
*        a rectilinear surface mesh with its associated scalar and vector sets.
*
*        Intended to help implement simple mesh. Just fill up the empty
*        methods of the following classes (search for PUT_YOUR_CODE_HERE): 
*         - MyTopologyIj :  topology template.
*         - MySurfaceGeometryRectilinear :  geometry template.
*         - MyScalarSetIj :  scalar set template.
*         - MyVectorSetIj :  vector set template.
* 
*        Hint: some should inherit both from MeshViz interfaces and the user's application data classes.
*
*        @note Nonmandatory methods are marked as optional.
*
*        For advanced implementations, refer to the MiSurfaceMeshRectilinear interface.
* 
*/

#include <MeshVizXLM/mesh/topology/MiTopologyIj.h>
/**
* Class defining the topology of the mesh.
*/
class MyTopologyIj : public MiTopologyIj
{
public:
  /**
  * Returns the number of cells on the first logical axis.
  */
  size_t getNumCellsI() const
  {
     // PUT_YOUR_CODE_HERE.
  }

  /**
  * Returns the number of cells on the second logical axis.
  */
  size_t getNumCellsJ() const
  {
    // PUT_YOUR_CODE_HERE.
  }

  /** 
  * Returns true if the topology contains dead cells.
  * When false, the cells traversal can be optimized by not testing 
  * the isDead() method of each individual cells.
  */ 
  bool hasDeadCells() const
  {
    // PUT_YOUR_CODE_HERE (Optional).
    // Required only if the topology has dead cells, remove this method otherwise to use 
    // the default implementation that always returns false.
  }

 /** 
  * Returns true if the cell of index (i,j) should be ignored.
  * This value is ignored if the hasDeadCell() method returns false.
  * @param (i,j) the index of the cell to check
  */ 
  bool isDead(size_t i,size_t j) const
  {
    // PUT_YOUR_CODE_HERE (Optional).
    // Required only if the topology has dead cells, remove this method otherwise to use 
    // the default implementation that always returns false.
  }

  /**
  * Returns a time stamp on this topology. 
  */
  size_t getTimeStamp() const
  {
    // PUT_YOUR_CODE_HERE (see MxTimeStamp).
    // When the content of the topology changes, the time stamp must also change.
    // The time stamp allows MeshViz to be aware of any change to this topology.
  }

};

#include <MeshVizXLM/mesh/geometry/MiSurfaceGeometryRectilinear.h>
/**
* Class defining the geometry of the mesh.
*/
class MySurfaceGeometryRectilinear : public MiSurfaceGeometryRectilinear //, public YourGeometry
// Advised to inherit from the class containing your application geometry.
{
public:
  /**
  * Returns the i-th coordinate along the X axis.
  */
  double getX(size_t i) const
  {
    // PUT_YOUR_CODE_HERE. 
  }

  /**
  * Returns the j-th coordinate along the Y axis.
  */
  double getY(size_t j) const
  {
    // PUT_YOUR_CODE_HERE. 
  }

  /**
  * Returns the normal of the plane on which the rectilinear mesh is defined.
  */
  MbVec3d getNormal() const 
  {
    // PUT_YOUR_CODE_HERE (Optional). Remove this method if using the default 
    // value (0,0,1) defining the XY plane.
    // Note: other values currently handled for the geometry are (1,0,0) and (0,1,0)
    // defining the YZ and ZX planes.
  }

  /**
  * Returns the distance to the origin of the plane on which the rectilinear mesh is defined.
  */
  double getDistance() const 
  {
    // PUT_YOUR_CODE_HERE (Optional). Remove this method if using the default value 0. 
  }

  /**
  * Returns a time stamp on this geometry.
  */
  size_t getTimeStamp() const
  {
    // PUT_YOUR_CODE_HERE (see MxTimeStamp).
    // When the content of the geometry changes, the time stamp must also change.
    // The time stamp allows MeshViz to be aware of any change to this geometry.
  }
};

#include <MeshVizXLM/mesh/MiSurfaceMeshRectilinear.h>
/**
* Class defining a rectilinear surface mesh.
*/
class MySurfaceMeshRectilinear : public MiSurfaceMeshRectilinear
{

public:
  /**
  * Returns the geometry of this mesh. 
  */
  const MiSurfaceGeometryRectilinear& getGeometry() const
  {
    return m_geometry;
  }

  /**
  * Returns the topology of this mesh. 
  */
  const MiTopologyIj& getTopology() const
  {
    return m_topology;
  }


private:
  MySurfaceGeometryRectilinear m_geometry;
  MyTopologyIj m_topology;

};

#include <MeshVizXLM/mesh/data/MiDataSetIj.h>
/**
* Class defining a scalar set associated to the mesh.
*/
class MyScalarSetIj : public MiScalardSetIj //, public YourData
// Advised to inherit from the class containing your application data.
{
public:

  /**
  * Returns the ij-th value of this set.
  */
  double get(size_t i,size_t j) const
  {
    // PUT_YOUR_CODE_HERE.
  }

  /**
  * Returns a time stamp on this scalar set.
  */
  size_t getTimeStamp() const
  {
    // PUT_YOUR_CODE_HERE (see MxTimeStamp).
    // When the content of the scalar set changes, the time stamp must also change.
    // The time stamp allows MeshViz to be aware of any change to this scalar set.
  }

  /**
  * Returns the name of this scalar set.
  */
  std::string getName() const
  {
    // PUT_YOUR_CODE_HERE.
  }

  /**
  * Returns the data binding of this scalar set.
  */
  DataBinding  getBinding() const
  {
    // PUT_YOUR_CODE_HERE (see MiDataSet::DataBinding).
  }

};

#include <MeshVizXLM/mesh/data/MiDataSetIj.h>
/**
* Class defining a vector set associated to the mesh.
*/
class MyVectorSetIj : public MiVec3dSetIj //, public YourData
// Advised to inherit from the class containing your application data.
{
public:

  /**
  * Returns the ij-th vector of this set.
  */
  MbVec3d get(size_t i, size_t j) const
  {
    // PUT_YOUR_CODE_HERE.
  }

  /**
  * Returns a time stamp on this vector set.
  */
  size_t getTimeStamp() const
  {
    // PUT_YOUR_CODE_HERE (see MxTimeStamp).
    // When the content of the vector set changes, the time stamp must also change.
    // The time stamp allows MeshViz to be aware of any change to this vector set.
  }

  /**
  * Returns the name of this vector set.
  */
  std::string getName() const
  {
    // PUT_YOUR_CODE_HERE.
  }

  /**
  * Returns the data binding of this vector set.
  */
  DataBinding  getBinding() const
  {
    // PUT_YOUR_CODE_HERE (see MiDataSet::DataBinding).
  }

};

#endif 







