/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2019 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Martial Bonaventure (Mar 2010)
**=======================================================================*/

#ifndef _MyVolumeMeshHexahedronIjk_H
#define _MyVolumeMeshHexahedronIjk_H

/**
* @DTEXT Structured hexahedron mesh template. 
* 
* @ingroup MeshVizXLM_Mesh_Templates
* 
* @DESCRIPTION
*        Header file to be completed including all required classes to define 
*        a structured hexahedron mesh with its associated scalar and vector sets.
*
*        Intended to help implement simple mesh. Just fill up the empty
*        methods of the following classes (search for PUT_YOUR_CODE_HERE): 
*         - MyHexahedronTopologyExplicitIjk :  topology template.
*         - MyGeometryI :  geometry template.
*         - MyScalarSetIjk :  per cell scalar set template.
*         - MyScalarSetI :  per node scalar set template.
*         - MyVectorSetIjk : per cell vector set template.
*         - MyVectorSetI :  per node vector set template.
*
*        Hint: some should inherit both from MeshViz interfaces and the user's application data classes.
*
*        @note Nonmandatory methods are marked as optional.
*
*        For advanced implementations, refer to the MiVolumeMeshHexahedronIjk interface.
* 
*/

#include <MeshVizXLM/mesh/topology/MiHexahedronTopologyExplicitIjk.h>
/**
* Class defining the topology of the mesh.
*/
class MyHexahedronTopologyExplicitIjk : public MiHexahedronTopologyExplicitIjk
{
public:
  /**
  * Returns the number of cells on the first logical axis.
  */
  size_t getNumCellsI() const
  {
     // PUT_YOUR_CODE_HERE.
  }

  /**
  * Returns the number of cells on the second logical axis.
  */
  size_t getNumCellsJ() const
  {
    // PUT_YOUR_CODE_HERE.
  }

  /**
  * Returns the number of cells on the third logical axis.
  */
  size_t getNumCellsK() const
  {
    // PUT_YOUR_CODE_HERE.
  }

  /**
  * Returns the 8 indices of a cell of this topology. The cell 
  * is identified by three ids i,j,k.
  */
  void getCellNodeIndices(size_t i, size_t j, size_t k, size_t& n0, size_t& n1, size_t& n2, size_t& n3,
                                                        size_t& n4, size_t& n5, size_t& n6, size_t& n7)  const
  {
    // PUT_YOUR_CODE_HERE.
  }

  /** 
  * Returns true if the topology contains dead cells.
  * When false, the cells traversal can be optimized by not testing 
  * the isDead() method of each individual cells.
  */ 
  bool hasDeadCells() const
  {
    // PUT_YOUR_CODE_HERE (Optional).
    // Required only if the topology has dead cells, remove this method otherwise to use 
    // the default implementation that always returns false.
  }

 /** 
  * Returns true if the cell of index (i,j,k) should be ignored.
  * This value is ignored if the hasDeadCell() method returns false.
  * @param (i,j,k) the index of the cell to check
  */ 
  bool isDead(size_t i,size_t j, size_t k) const
  {
    // PUT_YOUR_CODE_HERE (Optional).
    // Required only if the topology has dead cells, remove this method otherwise to use 
    // the default implementation that always returns false.
  }

  /**
  * Returns the last node id + 1 used by this topology. This topology uses only 
  * node index in the interval [beginNodeId,EndNodeId[. Thus the maximum node
  * index used by the topology is getEndNodeId() - 1 and the number of 
  * nodes used by this topology is getEndNodeId() - getBeginNodeId().
  */
  size_t getEndNodeId() const
  {
    // PUT_YOUR_CODE_HERE.
  }

  /**
  * Returns the first node id used by this topology. This topology uses only 
  * node index in the interval [beginNodeId,EndNodeId[. Thus the maximum node
  * index used by the topology is getEndNodeId() - 1 and the number of 
  * nodes used by this topology is getEndNodeId() - getBeginNodeId().
  */
  size_t getBeginNodeId() const
  {
    // PUT_YOUR_CODE_HERE (Optional).
    // Remove this method to use the default implementation that returns 0.
  }

  /**
  * Returns a time stamp on this topology. 
  */
  size_t getTimeStamp() const
  {
    // PUT_YOUR_CODE_HERE (see MxTimeStamp).
    // When the content of the topology changes, the time stamp must also change.
    // The time stamp allows MeshViz to be aware of any change to this topology.
  }

};

#include <MeshVizXLM/mesh/geometry/MiGeometryI.h>
/**
* Class defining the geometry of the mesh.
*/
class MyGeometryI : public MiGeometryI //, public YourGeometry
// Advised to inherit from the class containing your application geometry.
{
public:
  /**
  * Returns the i-th coordinate of this geometry.
  */
  MbVec3d getCoord(size_t i) const
  {
    // PUT_YOUR_CODE_HERE.
  }

  /**
  * Returns a time stamp on this geometry.
  */
  size_t getTimeStamp() const
  {
    // PUT_YOUR_CODE_HERE (see MxTimeStamp).
    // When the content of the geometry changes, the time stamp must also change.
    // The time stamp allows MeshViz to be aware of any change to this geometry.
  }
};

#include <MeshVizXLM/mesh/MiVolumeMeshHexahedronIjk.h>
/**
* Class defining a structured hexahedron mesh.
*/
class MyVolumeMeshHexahedronIjk : public MiVolumeMeshHexahedronIjk
{

public:
  /**
  * Returns the unstructured geometry of this mesh. 
  */
  const MiGeometryI& getGeometry() const
  {
    return m_geometry;
  }

  /**
  * Returns the topology of this mesh. 
  */
  const MiHexahedronTopologyExplicitIjk& getTopology() const
  {
    return m_topology;
  }


private:
  MyGeometryI m_geometry;
  MyHexahedronTopologyExplicitIjk m_topology;

};

#include <MeshVizXLM/mesh/data/MiDataSetI.h>
/**
* Class defining a scalar set associated to the mesh binded per node.
*/
class MyScalarSetI : public MiScalardSetI //, public YourData
// Advised to inherit from the class containing your application data.
{
public:

  /**
  * Returns the i-th value of this set.
  */
  double get(size_t i) const
  {
    // PUT_YOUR_CODE_HERE.
  }

  /**
  * Returns a time stamp on this scalar set.
  */
  size_t getTimeStamp() const
  {
    // PUT_YOUR_CODE_HERE (see MxTimeStamp).
    // When the content of the scalar set changes, the time stamp must also change.
    // The time stamp allows MeshViz to be aware of any change to this scalar set.
  }

  /**
  * Returns the name of this scalar set.
  */
  std::string getName() const
  {
    // PUT_YOUR_CODE_HERE.
  }

  /**
  * Returns the data binding of this scalar set.
  */
  DataBinding  getBinding() const
  {
    return MiDataSet::PER_NODE;
  }

};

#include <MeshVizXLM/mesh/data/MiDataSetIjk.h>
/**
* Class defining a scalar set associated to the mesh binded per cell.
*/
class MyScalarSetIjk : public MiScalardSetIjk //, public YourData
// Advised to inherit from the class containing your application data.
{
public:

  /**
  * Returns the ijk-th value of this set.
  */
  double get(size_t i,size_t j,size_t k) const
  {
    // PUT_YOUR_CODE_HERE.
  }

  /**
  * Returns a time stamp on this scalar set.
  */
  size_t getTimeStamp() const
  {
    // PUT_YOUR_CODE_HERE (see MxTimeStamp).
    // When the content of the scalar set changes, the time stamp must also change.
    // The time stamp allows MeshViz to be aware of any change to this scalar set.
  }

  /**
  * Returns the name of this scalar set.
  */
  std::string getName() const
  {
    // PUT_YOUR_CODE_HERE.
  }

  /**
  * Returns the data binding of this scalar set.
  */
  DataBinding  getBinding() const
  {
    return MiDataSet::PER_CELL;
  }

};

#include <MeshVizXLM/mesh/data/MiDataSetI.h>
/**
* Class defining a vector set associated to the mesh binded per node.
*/
class MyVectorSetI : public MiVec3dSetI //, public YourData
// Advised to inherit from the class containing your application data.
{
public:

  /**
  * Returns the i-th vector of this set.
  */
  MbVec3d get(size_t i) const
  {
    // PUT_YOUR_CODE_HERE.
  }

  /**
  * Returns a time stamp on this vector set.
  */
  size_t getTimeStamp() const
  {
    // PUT_YOUR_CODE_HERE (see MxTimeStamp).
    // When the content of the vector set changes, the time stamp must also change.
    // The time stamp allows MeshViz to be aware of any change to this vector set.
  }

  /**
  * Returns the name of this vector set.
  */
  std::string getName() const
  {
    // PUT_YOUR_CODE_HERE.
  }

  /**
  * Returns the data binding of this vector set.
  */
  DataBinding  getBinding() const
  {
    return MiDataSet::PER_NODE;
  }

};

#include <MeshVizXLM/mesh/data/MiDataSetIjk.h>
/**
* Class defining a vector set associated to the mesh binded per node.
*/
class MyVectorSetIjk : public MiVec3dSetIjk //, public YourData
// Advised to inherit from the class containing your application data.
{
public:

  /**
  * Returns the ijk-th vector of this set.
  */
  MbVec3d get(size_t i, size_t j, size_t k) const
  {
    // PUT_YOUR_CODE_HERE.
  }

  /**
  * Returns a time stamp on this vector set.
  */
  size_t getTimeStamp() const
  {
    // PUT_YOUR_CODE_HERE (see MxTimeStamp).
    // When the content of the vector set changes, the time stamp must also change.
    // The time stamp allows MeshViz to be aware of any change to this vector set.
  }

  /**
  * Returns the name of this vector set.
  */
  std::string getName() const
  {
    // PUT_YOUR_CODE_HERE.
  }

  /**
  * Returns the data binding of this vector set.
  */
  DataBinding  getBinding() const
  {
    return MiDataSet::PER_CELL;
  }

};

#endif 







