/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2019 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Martial Bonaventure (Mar 2010)
**=======================================================================*/

#ifndef _MyVolumeMeshRegular_H
#define _MyVolumeMeshRegular_H

/**
* @DTEXT Regular volume mesh template. 
* 
* @ingroup MeshVizXLM_Mesh_Templates
* 
* @DESCRIPTION
*        Header file to be completed including all required classes to define 
*        a regular volume mesh with its associated scalar and vector sets.
*
*        Intended to help implement simple mesh. Just fill up the empty
*        methods of the following classes (search for PUT_YOUR_CODE_HERE): 
*         - MyTopologyIjk :  topology template.
*         - MyGeometryRegular :  geometry template.
*         - MyScalarSetIjk :  scalar set template.
*         - MyVectorSetIjk :  vector set template.
*
*        Hint: some should inherit both from MeshViz interfaces and the user's application data classes.
*
*        @note Nonmandatory methods are marked as optional.
*
*        For advanced implementations, refer to the MiMeshRegular interface.
* 
*/

#include <MeshVizXLM/mesh/topology/MiTopologyIjk.h>
/**
* Class defining the topology of the mesh.
*/
class MyTopologyIjk : public MiTopologyIjk
{
public:
  /**
  * Returns the number of cells on the first logical axis.
  */
  size_t getNumCellsI() const
  {
     // PUT_YOUR_CODE_HERE.
  }

  /**
  * Returns the number of cells on the second logical axis.
  */
  size_t getNumCellsJ() const
  {
    // PUT_YOUR_CODE_HERE.
  }

  /**
  * Returns the number of cells on the third logical axis.
  */
  size_t getNumCellsK() const
  {
    // PUT_YOUR_CODE_HERE.
  }

  /** 
  * Returns true if the topology contains dead cells.
  * When false, the cells traversal can be optimized by not testing 
  * the isDead() method of each individual cells.
  */ 
  bool hasDeadCells() const
  {
    // PUT_YOUR_CODE_HERE (Optional).
    // Required only if the topology has dead cells, remove this method otherwise to use 
    // the default implementation that always returns false.
  }

 /** 
  * Returns true if the cell of index (i,j,k) should be ignored.
  * This value is ignored if the hasDeadCell() method returns false.
  * @param (i,j,k) the index of the cell to check
  */ 
  bool isDead(size_t i,size_t j, size_t k) const
  {
    // PUT_YOUR_CODE_HERE (Optional).
    // Required only if the topology has dead cells, remove this method otherwise to use 
    // the default implementation that always returns false.
  }

  /**
  * Returns a time stamp on this topology. 
  */
  size_t getTimeStamp() const
  {
    // PUT_YOUR_CODE_HERE (see MxTimeStamp).
    // When the content of the topology changes, the time stamp must also change.
    // The time stamp allows MeshViz to be aware of any change to this topology.
  }

};

#include <MeshVizXLM/mesh/geometry/MiGeometryRegular.h>
/**
* Class defining the geometry of the mesh.
*/
class MyGeometryRegular : public MiGeometryRegular
{
public:
  /**
  * Returns the minimum value of this set.
  */
  MbVec3d getMin() const 
  {
    // PUT_YOUR_CODE_HERE. 
  }

  /**
  * Returns the maximum value of this set.
  */
  MbVec3d getMax() const 
  {
    // PUT_YOUR_CODE_HERE.
  }

  /**
  * Returns a time stamp on this geometry.
  */
  size_t getTimeStamp() const
  {
    // PUT_YOUR_CODE_HERE (see MxTimeStamp).
    // When the content of the geometry changes, the time stamp must also change.
    // The time stamp allows MeshViz to be aware of any change to this geometry.
  }
};

#include <MeshVizXLM/mesh/MiVolumeMeshRegular.h>
/**
* Class defining a regular volume mesh.
*/
class MyVolumeMeshRegular : public MiVolumeMeshRegular
{

public:
  /**
  * Returns the geometry of this mesh. 
  */
  const MiGeometryRegular& getGeometry() const
  {
    return m_geometry;
  }

  /**
  * Returns the topology of this mesh. 
  */
  const MiTopologyIjk& getTopology() const
  {
    return m_topology;
  }


private:
  MyGeometryRegular m_geometry;
  MyTopologyIjk m_topology;

};

#include <MeshVizXLM/mesh/data/MiDataSetIjk.h>
/**
* Class defining a scalar set associated to the mesh.
*/
class MyScalarSetIjk : public MiScalardSetIjk //, public YourData
// Advised to inherit from the class containing your application data.
{
public:

  /**
  * Returns the ijk-th value of this set.
  */
  double get(size_t i,size_t j,size_t k) const
  {
    // PUT_YOUR_CODE_HERE.
  }

  /**
  * Returns a time stamp on this scalar set.
  */
  size_t getTimeStamp() const
  {
    // PUT_YOUR_CODE_HERE (see MxTimeStamp).
    // When the content of the scalar set changes, the time stamp must also change.
    // The time stamp allows MeshViz to be aware of any change to this scalar set.
  }

  /**
  * Returns the name of this scalar set.
  */
  std::string getName() const
  {
    // PUT_YOUR_CODE_HERE.
  }

  /**
  * Returns the data binding of this scalar set.
  */
  DataBinding  getBinding() const
  {
    // PUT_YOUR_CODE_HERE (see MiDataSet::DataBinding).
  }

};

#include <MeshVizXLM/mesh/data/MiDataSetIjk.h>
/**
* Class defining a vector set associated to the mesh.
*/
class MyVectorSetIjk : public MiVec3dSetIjk //, public YourData
// Advised to inherit from the class containing your application data.
{
public:

  /**
  * Returns the ijk-th vector of this set.
  */
  MbVec3d get(size_t i, size_t j, size_t k) const
  {
    // PUT_YOUR_CODE_HERE.
  }

  /**
  * Returns a time stamp on this vector set.
  */
  size_t getTimeStamp() const
  {
    // PUT_YOUR_CODE_HERE (see MxTimeStamp).
    // When the content of the vector set changes, the time stamp must also change.
    // The time stamp allows MeshViz to be aware of any change to this vector set.
  }

  /**
  * Returns the name of this vector set.
  */
  std::string getName() const
  {
    // PUT_YOUR_CODE_HERE.
  }

  /**
  * Returns the data binding of this vector set.
  */
  DataBinding  getBinding() const
  {
    // PUT_YOUR_CODE_HERE (see MiDataSet::DataBinding).
  }

};

#endif 







