/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2019 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Martial Bonaventure (Mar 2010)
**=======================================================================*/

#ifndef _MyVolumeMeshUnstructured_H
#define _MyVolumeMeshUnstructured_H

/**
* @DTEXT Unstructured volume mesh template.
* 
* @ingroup MeshVizXLM_Mesh_Templates
* 
* @DESCRIPTION
*        Header file to be completed including all required classes to define 
*        an unstructured volume mesh with its associated scalar and vector sets.
*
*        Intended to help implement simple mesh. Just fill up the empty 
*        methods of the following classes (search for PUT_YOUR_CODE_HERE):
*         - MyVolumeCell : volume cell template.
*         - MyVolumeTopologyExplicitI :  volume topology template.
*         - MyGeometryI :  geometry template.
*         - MyScalarSetI :  scalar set template.
*         - MyVectorSetI :  vector set template.
*
*        Hint: some should inherit both from MeshViz interfaces and the user's application data classes.
*
*        @note Nonmandatory methods are marked as optional.
*
*        For advanced implementations, refer to the MiVolumeMeshUnstructured interface.
* 
*/

#include <MeshVizXLM/mesh/cell/MiVolumeCell.h>
/**
* Class defining a volume cell of the mesh
*/
class MyVolumeCell : public MiVolumeCell
{
public:
  /**
  * Gets the number of nodes.
  */
  size_t getNumNodes() const
  {
    // PUT_YOUR_CODE_HERE.
  }

  /**
  * Gets the index (in the mesh) of a node.
  * @param[in] node Node number (where: 0 <= node < getNumNodes()).
  */
  size_t getNodeIndex(size_t node) const
  {
    // PUT_YOUR_CODE_HERE.
  }

  /**
  * Gets the number of facets.
  */
  size_t getNumFacets() const
  {
    // PUT_YOUR_CODE_HERE.
  }

  /**
  * Appends the array of node indices belonging to a given facet to facetNode.
  * 
  * @param[in] facet The index of the facet (where 0 <= facet < getNumFacets()).
  * @param facetNodes A vector in which the node indices of the facet will be appended. 
  * @return the number of nodes appended in facetNodes.
  */
  size_t appendNodesIndexOfFacet (size_t facet, std::vector<size_t>& facetNodes) const
  {
    // PUT_YOUR_CODE_HERE. 
    // The implementation must use the push_back() method to add elements into the vector.
    // The given vector should not be cleared by this method.
  }

    /**
  * Appends the array of local node indices belonging to a given facet to facetNodes.@BR
  * 
  * @param[in] facet The index of the facet (where 0 <= facet < getNumFacets()).
  * @param facetNodes A vector in which the local node indices of the facet will be appended. 
  * @return the number of nodes added.
  */
  size_t appendLocalNodesIndexOfFacet (size_t SO_UNUSED_PARAM(facet), std::vector<size_t>& SO_UNUSED_PARAM(facetNodes)) const
  {
    // PUT_YOUR_CODE_HERE (Optional). 
    // Requested only for polyhedral cells by MoPointProbe/MiPointProbeUnstructured, 
    //                                        MoMeshStreamline/MiStreamlineExtractUnstrctured,
    //                                        MoMeshGridPlaneSlice/MiGridPlaneSliceExtractUnstructured.
    // Remove this method otherwise.
    //
    // It must use the push_back() method to add elements to the vector.
    // The given vector should not be cleared by this method.
    // This method is similar to appendNodesIndexOfFacet() but facetNodes must be filled 
    // only with local node ids (i.e. node ids relative to the number of nodes in the cell): 
    // 0 <= facetNodes[i] < getNumNodes() for each i.
  }

  /**
  * Gets the list of topological polygons defining the part of the isosurface topology in this cell.
  */
  void getIsosurfTopology(unsigned char caseId, std::vector< std::pair<size_t,size_t> >& edgeList ) const
  {
    // PUT_YOUR_CODE_HERE (Optional).
    // Implementation provided for common volume cells (see MxXXXXCellExtract::getIsosurfTopology()).
    // Requested by MoMeshIsosurface/MiIsosurfExtractUnstructured, 
    //              MoMeshPlaneSlice/MiPlaneSliceExtractUnstructure,
    //              MoMeshSphereSlice/MiSphereSliceExtractUnstructured,
    //              MoMeshCylinderSlice/MiCylinderSliceExtractUnstrutured.
  }

  /**
  * Gets the relative size of the cell.
  *
  * @param[in] meshGeometry the geometry of the mesh. Used to retrieve the node coordinates
  * of this cell.
  *
  */
  double getRelativeSize(const MiGeometryI* meshGeometry) const 
  {
    // PUT_YOUR_CODE_HERE (Optional).
    // Used only by MoMeshCellShape to display node names if using the relative offset feature and
    // MoMeshStreamline/MiStreamlineExtractUnstructured to adapt the step integration to the size of the cell.
    // 
    // Must not return 0. For instance, use provided MxXXXXCellExtract::getLongestEdgeLength().
    // Remove this method if not needed or to use the default implementation that returns 1.
  }

  /**
  * Checks if a point is inside or outside a cell.
  *
  * @param[in] meshGeometry The geometry of the mesh. Used to retrieve the node coordinates
  * of this cell.
  * @param[in] point The point to be checked.
  * @param[out] weights containing at least as many elements as the number of 
  * nodes in this cell.
  * @return True if the point is inside the cell.
  *  
  */
  bool isPointInsideCell(const MiGeometryI& meshGeometry, 
                         const MbVec3d& point, 
                         std::vector<double>& weights) const
  {
    // PUT_YOUR_CODE_HERE (Optional).
    // Implementation provided for common volume cells (see MxXXXXCellExtract::isPointInsideCell())
    // Requested by MoPointProbe/MiPointProbeUnstructured, 
    //              MoMeshStreamline/MiStreamlineExtractUnstrctured,
    //              MoMeshGridPlaneSlice/MiGridPlaneSliceExtractUnstructured.
    // Remove this method otherwise.
    //
    // It is not nessessary to resize the weight vector array since 
    // extraction classes are optimized such as weight vectors passed to this method are
    // already allocated and large enough to retrieve all the computed weights.
  }

};

#include <MeshVizXLM/mesh/topology/MiVolumeTopologyExplicitI.h>
/**
* Class defining the volume topology of the mesh
*/
class MyVolumeTopologyExplicitI : public MiVolumeTopologyExplicitI
{
public:
  /**
  * Returns the number of cells.
  */
  size_t getNumCells() const
  {
    // PUT_YOUR_CODE_HERE.
  }

  /** 
  * Returns true if the topology contains dead cells.
  * When false, the cells traversal can be optimized by not testing 
  * the isDead() method of each individual cells.
  */ 
  bool hasDeadCells() const
  {
    // PUT_YOUR_CODE_HERE (Optional).
    // Required only if the topology has dead cells, remove this method otherwise to use 
    // the default implementation that always returns false.
  }

 /** 
  * Returns true if the cell of index i should be ignored.
  * This value is ignored if the hasDeadCell() method returns false.
  * @param i the index of the cell to check
  */ 
  bool isDead(size_t i) const
  {
    // PUT_YOUR_CODE_HERE (Optional).
    // Required only if the topology has dead cells, remove this method otherwise to use 
    // the default implementation that always returns false.
  }

  /**
  * Returns a cell of this topology. The cell 
  * is identified by one id.
  */
  const MiVolumeCell* getCell(size_t id) const
  {
    // PUT_YOUR_CODE_HERE.
    // For instance, can return an instance of MyVolumeCell.
  }

  /**
  * Returns the last node id + 1 used by this topology. This topology uses only 
  * node index in the interval [beginNodeId,EndNodeId[. Thus the maximum node
  * index used by the topology is getEndNodeId() - 1 and the number of 
  * nodes used by this topology is getEndNodeId() - getBeginNodeId().
  */
  size_t getEndNodeId() const
  {
    // PUT_YOUR_CODE_HERE.
  }

  /**
  * Returns the first node id used by this topology. This topology uses only 
  * node index in the interval [beginNodeId,EndNodeId[. Thus the maximum node
  * index used by the topology is getEndNodeId() - 1 and the number of 
  * nodes used by this topology is getEndNodeId() - getBeginNodeId().
  */
  size_t getBeginNodeId() const
  {
    // PUT_YOUR_CODE_HERE (Optional).
    // Remove this method to use the default implementation that returns 0.
  }

  /**
  * Returns a time stamp on this topology. 
  */
  size_t getTimeStamp() const
  {
    // PUT_YOUR_CODE_HERE (see MxTimeStamp).
    // When the content of the topology changes, the time stamp must also change.
    // The time stamp allows MeshViz to be aware of any change to this topology.
  }

};

#include <MeshVizXLM/mesh/geometry/MiGeometryI.h>
/**
* Class defining the geometry of the mesh
*/
class MyGeometryI : public MiGeometryI //, public YourGeometry
// Advised to inherit from the class containing your application geometry.
{
public:
  /**
  * Returns the i-th coordinate of this geometry.
  */
  MbVec3d getCoord(size_t i) const
  {
    // PUT_YOUR_CODE_HERE.
  }

  /**
  * Returns a time stamp on this geometry.
  */
  size_t getTimeStamp() const
  {
    // PUT_YOUR_CODE_HERE (see MxTimeStamp).
    // When the content of the geometry changes, the time stamp must also change.
    // The time stamp allows MeshViz to be aware of any change to this geometry.
  }
};

#include <MeshVizXLM/mesh/MiVolumeMeshUnstructured.h>
/**
* Class defining an unstructured volume mesh
*/
class MyVolumeMeshUnstructured : public MiVolumeMeshUnstructured
{

public:
  /**
  * Returns the unstructured geometry of this mesh. 
  */
  const MiGeometryI& getGeometry() const
  {
    return m_geometry;
  }

  /**
  * Returns the topology of this mesh. 
  */
  const MiVolumeTopologyExplicitI& getTopology() const
  {
    return m_topology;
  }


private:
  MyGeometryI m_geometry;
  MyVolumeTopologyExplicitI m_topology;

};

#include <MeshVizXLM/mesh/data/MiDataSetI.h>
/**
* Class defining a scalar set associated to the unstructured volume mesh
*/
class MyScalarSetI : public MiScalardSetI //, public YourData
// Advised to inherit from the class containing your application data.
{
public:

  /**
  * Returns the i-th value of this set.
  */
  double get(size_t i) const
  {
    // PUT_YOUR_CODE_HERE.
  }

  /**
  * Returns a time stamp on this scalar set.
  */
  size_t getTimeStamp() const
  {
    // PUT_YOUR_CODE_HERE (see MxTimeStamp).
    // When the content of the scalar set changes, the time stamp must also change.
    // The time stamp allows MeshViz to be aware of any change to this scalar set.
  }

  /**
  * Returns the name of this scalar set.
  */
  std::string getName() const
  {
    // PUT_YOUR_CODE_HERE.
  }

  /**
  * Returns the data binding of this scalar set.
  */
  DataBinding  getBinding() const
  {
    // PUT_YOUR_CODE_HERE (see MiDataSet::DataBinding).
  }

};

#include <MeshVizXLM/mesh/data/MiDataSetI.h>
/**
* Class defining a vector set associated to the unstructured volume mesh
*/
class MyVectorSetI : public MiVec3dSetI //, public YourData
// Advised to inherit from the class containing your application data.
{
public:

  /**
  * Returns the i-th vector of this set.
  */
  MbVec3d get(size_t i) const
  {
    // PUT_YOUR_CODE_HERE.
  }

  /**
  * Returns a time stamp on this vector set.
  */
  size_t getTimeStamp() const
  {
    // PUT_YOUR_CODE_HERE (see MxTimeStamp).
    // When the content of the vector set changes, the time stamp must also change.
    // The time stamp allows MeshViz to be aware of any change to this vector set.
  }

  /**
  * Returns the name of this vector set.
  */
  std::string getName() const
  {
    // PUT_YOUR_CODE_HERE.
  }

  /**
  * Returns the data binding of this vector set.
  */
  DataBinding  getBinding() const
  {
    // PUT_YOUR_CODE_HERE (see MiDataSet::DataBinding).
  }

};


#endif 







