/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MBTETRAHEDRONCELLSSET_H
#define _MBTETRAHEDRONCELLSSET_H

#ifdef _WIN32
#pragma warning(push)
#pragma warning(disable:4250)
#pragma warning(disable:4251)
#endif

#include <MeshVizXLM/mesh/topology/MiVolumeTopologyExplicitI.h>
#include <topology/MbTopologyI.h>
#include <cell/MbTetrahedronCell.h>
#include <MbError.h>

#include <Inventor/STL/algorithm>


/**
* @DTEXT Build a set of Tetrahedron.
* 
* @ingroup MeshVizXLM_Implement_Topology
*/
class MbTetrahedronCellsSet : virtual public MiVolumeTopologyExplicitI, public MbTopologyI
{
public:

  /** 
  * Construct an empty set of tetrahedrons.
  */
  MbTetrahedronCellsSet();

  /** 
  * Defines a new list of tetrahedrons according to their indices.
  * Thus distance(endId-beginId) should be a multiple of 4.
  */
  template <typename _NodeIdIter>
  void assign(_NodeIdIter beginId, _NodeIdIter endId);

  /**
  * Returns the i-th cell of this set.
  */
  virtual const MbTetrahedronCell* getCell(size_t id) const;


  /**
  * Returns the number of cells in the set.
  */
  virtual size_t getNumCells() const;

  /**
  * Returns the first node index in this tetra geometry.
  */
  virtual size_t getBeginNodeId() const
  {
    return m_beginNodeId;
  }

  /**
  * Returns the end node index in this tetra geometry.
  */
  virtual size_t getEndNodeId() const
  {
    return m_endNodeId;
  }

protected:
  std::vector<MbTetrahedronCell> m_cells;
  size_t m_endNodeId;
  size_t m_beginNodeId;
};


//-----------------------------------------------------------------------------
inline
MbTetrahedronCellsSet::MbTetrahedronCellsSet()
: m_endNodeId(0),m_beginNodeId(0)
{
}


//-----------------------------------------------------------------------------
inline const MbTetrahedronCell* 
MbTetrahedronCellsSet::getCell(size_t cellId) const
{
#ifndef MBMESH_DONT_USE_ASSERT
  if (hasDeadCells() && isDead(cellId)) 
    throw MbError("accessing dead cells");
#endif
  return &(m_cells[cellId]);
}

//-----------------------------------------------------------------------------
inline size_t
MbTetrahedronCellsSet::getNumCells() const 
{
  return m_cells.size();
}

//-----------------------------------------------------------------------------
template <typename _NodeIdIter>
inline void 
MbTetrahedronCellsSet::assign(_NodeIdIter beginId, _NodeIdIter endId)
{
  size_t numIds = std::distance(beginId,endId);
  size_t numCells = (numIds - numIds%4)/4;

  m_beginNodeId = std::numeric_limits<size_t>::max();
  m_cells.clear();
  m_cells.reserve(numCells);
  _NodeIdIter it = beginId;
  size_t i, node[4];
  for (i=0; i<numCells; ++i)
  {
    for (size_t j = 0; j < 4; ++j,++it)
    {
      node[j] = *it;
      if (*it+1 > m_endNodeId) m_endNodeId = *it+1;
      if (*it < m_beginNodeId) m_beginNodeId = *it;
    }
    m_cells.push_back(MbTetrahedronCell(node[0],node[1],node[2],node[3]));
  }
  m_timeStamp = MxTimeStamp::getTimeStamp();
}

#ifdef _WIN32
#pragma warning(pop)
#endif

#endif

