/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MBTOPOLOGY_H
#define _MBTOPOLOGY_H

#include <MeshVizXLM/mesh/topology/MiTopology.h>
#include <MeshVizXLM/MxTimeStamp.h>
#include <Inventor/STL/vector>

//-----------------------------------------------------------------------------
/**
* @DTEXT List of volume cells.
* 
* @ingroup MeshVizXLM_Implement_Topology
* 
* @DESCRIPTION
*    A abstract omplementation for a mesh topology. 
* 
*/
class MbTopology : virtual public MiTopology
{
public:

#ifdef MBMESH_DONT_USE_STL
  virtual ~MbTopology()
  {
    delete [] m_deadCells;
  }
#endif

  /**
  * Returns a time stamp on this topology. When the content of the topology 
  * changes, the time stamp must also change. The time stamp allows MeshViz 
  * to be aware of any change to this topology.
  */
  virtual size_t getTimeStamp() const {return m_timeStamp;}

  /** 
  * Returns true if the topology contains dead cells.
  * When false, the cells traversal can be optimized by not testing the isDead() method of each individual cells.
  * The default implementation returns always false.
  */ 
  virtual bool hasDeadCells() const 
  { 
#ifndef MBMESH_DONT_USE_STL
    return !m_deadCells.empty();
#else
    return m_deadCells != NULL;
#endif
  }

  /**
  * @internal
  * Simulate a modification to this topology
  */
  void touch()
  {
    m_timeStamp = MxTimeStamp::getTimeStamp();
  }

protected:
  /*
  * abstract class
  */
  MbTopology()
  : MiTopology()
#ifdef MBMESH_DONT_USE_STL
    ,m_deadCells(NULL)
#endif
  , m_timeStamp(MxTimeStamp::getTimeStamp())
  {}

#ifndef MBMESH_DONT_USE_STL
  std::vector<bool> m_deadCells;
#else
  bool* m_deadCells;
#endif
  size_t m_timeStamp;

};


#endif


