/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MBTOPOLOGYI_H
#define _MBTOPOLOGYI_H

#ifdef _WIN32
#pragma warning(push)
#pragma warning(disable:4250)
#pragma warning(disable:4251)
#endif

#include <MeshVizXLM/mesh/topology/MiTopologyI.h>
#include <topology/MbTopology.h>
#include <Inventor/STL/cassert>

//-----------------------------------------------------------------------------
/**
* @DTEXT List of volume cells.
* 
* @ingroup MeshVizXLM_Implement_Topology
* 
* @DESCRIPTION
*    An abstract implementation for a I implicit mesh topology. 
* 
*/
class MbTopologyI : virtual public MiTopologyI, public MbTopology
{
public:

  /** 
  * Assign a list of boolean flags defining if a cell is dead or not.
  * The number of flags given must equal the number of cells.
  * Thus distance(endId-beginId) should equals the number of cells.
  */
  template <typename _BoolIter>
  void assignDeadFlags(_BoolIter beginId, _BoolIter endId);

 /** 
  * Returns true if the cell of index i should be ignored.
  * This value is ignored if the hasDeadCell() method returns false.
  * The default implementation returns always false.
  * @param i the index of the cell to check
  */ 
  virtual bool isDead(size_t i) const;

protected:
  /*
  * abstract class
  */
  MbTopologyI()
  : MiTopologyI()
  , MbTopology()
  {}

};

//-----------------------------------------------------------------------------
inline bool 
MbTopologyI::isDead(size_t cellId) const 
{ 
  assert ( cellId < getNumCells() ); // check cellId < #cells
  return m_deadCells[cellId]; 
}

//-----------------------------------------------------------------------------
template <typename _BoolIter>
inline void 
MbTopologyI::assignDeadFlags(_BoolIter beginId, _BoolIter endId)
{
#ifndef MBMESH_DONT_USE_STL
  m_deadCells.assign(beginId,endId);
#else
  delete m_deadCells;
  m_deadCells = new bool[this->getNumCells()];
  size_t i = 0;
  for (_BoolIter it = beginId; it != endId; ++it,++i)
    m_deadCells[i] = *it;
#endif
  m_timeStamp = MxTimeStamp::getTimeStamp();
}

#ifdef _WIN32
#pragma warning(pop)
#endif

#endif


