/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _MBTOPOLOGYIJK_H
#define _MBTOPOLOGYIJK_H

#ifdef _WIN32
#pragma warning(push)
#pragma warning(disable:4250)
#pragma warning(disable:4251)
#endif

#include <MeshVizXLM/mesh/topology/MiTopologyIjk.h>
#include <topology/MbTopology.h>
#include <MbIjkToI.h>

#ifndef MBMESH_DONT_USE_ASSERT
#include <Inventor/STL/cassert>
#endif

//-----------------------------------------------------------------------------
/**
* @DTEXT List of volume cells.
* 
* @ingroup MeshVizXLM_Implement_Topology
* 
* @DESCRIPTION
*    An implementation for a IJK implicit mesh topology. 
* 
*/
template <MiMeshIjk::StorageLayout layout = MiMeshIjk::LAYOUT_KJI>
class MbTopologyIjk : public MiTopologyIjk, public MbTopology, protected MbIjkToI<layout>
{
public:
  /** Constructor */
  MbTopologyIjk(size_t numCellI, size_t numCellJ, size_t numCellK)
  : MiTopologyIjk()
  , MbTopology()
  , MbIjkToI<layout>(numCellI,numCellJ,numCellK)
  , m_numI(numCellI)
  , m_numJ(numCellJ)
  , m_numK(numCellK)
  , m_hasDeadCells(false)
  {
#ifndef MBMESH_DONT_USE_STL
    m_deadCells.resize(numCellI*m_numJ*numCellK, false);
#else
    size_t numCells = numCellI*m_numJ*numCellK;
    m_deadCells = new bool[numCellI*m_numJ*numCellK];
    for (size_t i = 0; i < numCells; ++i)
      m_deadCells[i] = false;
#endif
  }

  /**
  * Returns the number of cells on the first logical axis.
  */
  virtual size_t getNumCellsI() const { return m_numI; }

  /**
  * Returns the number of cells on the second logical axis.
  */
  virtual size_t getNumCellsJ() const { return m_numJ; }

  /**
  * Returns the number of cells on the third logical axis.
  */
  virtual size_t getNumCellsK() const { return m_numK; }

  /**
  * Returns true if the mesh contains some dead cells.
  */
  virtual bool hasDeadCells() const { return m_hasDeadCells;}

  /** 
  * Returns true if the cell of index (i,j,k) should be ignored.
  * This value is ignored if the hasDeadCell() method returns false.
  * The default implementation returns always false.
  * @param (i,j,k) the index of the cell to check
  */ 
  virtual bool isDead(size_t i, size_t j, size_t k) const;

  /**
  * Set the dead flag of cell (i,j).
  */
  void setDeadFlag(size_t i, size_t j, size_t k, bool isDead=true);

protected:
  size_t m_numI;
  size_t m_numJ;
  size_t m_numK;
  bool m_hasDeadCells;

};

//-----------------------------------------------------------------------------
template <MiMeshIjk::StorageLayout layout>
inline bool
MbTopologyIjk<layout>::isDead(size_t i, size_t j, size_t k) const
{
#ifndef MBMESH_DONT_USE_ASSERT
  assert(i<m_numI && j<m_numJ && k<m_numK);
#endif
  return m_deadCells[this->getI(i,j,k)];
}


//-----------------------------------------------------------------------------
template <MiMeshIjk::StorageLayout layout>
inline void
MbTopologyIjk<layout>::setDeadFlag(size_t i, size_t j, size_t k, bool isDead)
{
  if (i<m_numI && j<m_numJ && k<m_numK) 
  {
    m_deadCells[this->getI(i,j,k)] = isDead;
    m_hasDeadCells |= isDead;
    m_timeStamp = MxTimeStamp::getTimeStamp();
  }
}

#ifdef _WIN32
#pragma warning(pop)
#endif

#endif


