#ifndef  _WheelHexa27Topology_h
#define  _WheelHexa27Topology_h

#include <MeshVizXLM/mesh/MiVolumeMeshUnstructured.h>
#include <MeshVizXLM/MxTimeStamp.h>

#include <cell/WheelHexahedron27Cell.h>

#include <Inventor/STL/vector>

//-----------------------------------------------------------------------------
class WheelHexa27Topology : public MiVolumeTopologyExplicitI
{
public:
  WheelHexa27Topology(size_t numCellI, size_t numCellJ, size_t numCellK); 

  virtual const MiVolumeCell* getCell(size_t id) const
  {
    return &m_cells[id];
  }

  virtual size_t getEndNodeId() const
  {
    return m_endNodeId;
  }

  virtual size_t getNumCells() const
  {
    return m_cells.size();
  }

  virtual size_t getTimeStamp() const 
  {
    return m_timestamp;
  }

  void touch()
  {
    m_timestamp = MxTimeStamp::getTimeStamp();
  }

private:
  size_t getNodeIndex(size_t i, size_t j, size_t k)
  {
    return k*(m_numNodeI*m_numNodeJ) + j*m_numNodeI + i;
  }

  size_t m_numCellI, m_numCellJ, m_numCellK;
  size_t m_numNodeI, m_numNodeJ, m_numNodeK;
  std::vector<WheelHexahedron27Cell> m_cells;
  size_t m_endNodeId;
  size_t m_timestamp;
};



#endif 


