#include <BasicHTMLGUIServiceListener.h>

#include <RemoteViz/Rendering/RenderArea.h>
#include <Inventor/ViewerComponents/nodes/SceneExaminer.h>

#include <Inventor/SoSceneManager.h>
#include <Inventor/touch/SoTouchManager.h>
#include <Inventor/nodes/SoCone.h>
#include <Inventor/nodes/SoGradientBackground.h>
#include <Inventor/nodes/SoMaterial.h>

void BasicHTMLGUIServiceListener::onInstantiatedRenderArea(std::shared_ptr<RemoteViz::Rendering::RenderArea> renderArea)
{
  // Instantiate the class overriding the renderAreaListener class to manage the renderArea events.
  auto renderAreaListener = std::make_shared<BasicHTMLGUIRenderAreaListener>();

  // Add the renderAreaListener instance as renderArea listener
  renderArea->addListener(renderAreaListener);

  // Instantiate a sceneExaminer to interact with the camera
  SceneExaminer *examiner = new SceneExaminer();

  // Add recognizers for gesture events
  renderArea->getTouchManager()->addDefaultRecognizers();

  /* Scene graph*/

  // Add the color switch
  SoSwitch *colorswitch = new SoSwitch();
  SoMaterial *material = new SoMaterial();
  material->diffuseColor.setValue(1.0,0,0);
  colorswitch->addChild(material);
  examiner->addChild(colorswitch);

  // Add the cone and the background
  examiner->addChild(new SoCone());
  examiner->addChild(new SoGradientBackground());

  // Apply the sceneExaminer node as renderArea scene graph
  renderArea->getSceneManager()->setSceneGraph(examiner);

  // viewall
  examiner->viewAll(renderArea->getSceneManager()->getViewportRegion());

}
