#include <ClientWorkbenchRenderAreaListener.h>

#include <RemoteViz/Rendering/RenderArea.h>
#include <RemoteViz/Rendering/Connection.h>
#include <RemoteViz/Rendering/ConnectionSettings.h>
#include <RemoteViz/Rendering/Client.h>
#include <RemoteViz/Rendering/ClientSettings.h>
#include <RemoteViz/Rendering/KeepFrameQualityPolicy.h>
#include <RemoteViz/Rendering/KeepFramesPerSecondPolicy.h>

#include <Inventor/SoSceneManager.h>
#include <Inventor/nodes/SoSeparator.h>

#include <string>
#include <list>
#include <sstream>

//--------------------------------------------------------------------------------
std::list<std::string> &split(const std::string &s, char delim, std::list<std::string> &elems) 
{
  std::stringstream ss(s);
  std::string item;
  while (std::getline(ss, item, delim)) 
  {
    elems.push_back(item);
  }
  return elems;
}

//--------------------------------------------------------------------------------
void ClientWorkbenchRenderAreaListener::onReceivedMessage(std::shared_ptr<RemoteViz::Rendering::RenderArea> renderArea, std::shared_ptr<RemoteViz::Rendering::Connection> sender, const std::string& message)
{
  std::list<std::string> elems;
  split(message, ' ', elems); // split the received message, pattern : "COMMAND ARGUMENT"

  std::string command = elems.front();
  elems.pop_front();
  std::string argument = elems.front();

  // parse the commands
  if ( command == "POLICY" )
  {
     if ( argument == "KeepFrameQuality" )
       sender->getSettings()->setFrameEncodingPolicy(std::make_shared<RemoteViz::Rendering::KeepFrameQualityPolicy>());
     else if ( argument == "KeepFramesPerSecond" )
       sender->getSettings()->setFrameEncodingPolicy(std::make_shared<RemoteViz::Rendering::KeepFramesPerSecondPolicy>());
  }
  else if ( command == "BANDWIDTH" )
  {
    sender->getClient()->getSettings()->setBandwidth(atoi(argument.c_str()));
  }
  else if ( command == "WIDTH" )
  {
    renderArea->resize(atoi(argument.c_str()),renderArea->getSceneManager()->getSize()[1]);
  }
  else if ( command == "HEIGHT" )
  {
    renderArea->resize(renderArea->getSceneManager()->getSize()[0], atoi(argument.c_str()));
  }

}
