#include <ClientWorkbenchServiceListener.h>

#include <RemoteViz/Rendering/RenderArea.h>

#include <Inventor/SoInput.h>
#include <Inventor/SoSceneManager.h>
#include <Inventor/touch/SoTouchManager.h>
#include <Inventor/nodes/SoCone.h>
#include <Inventor/nodes/SoGradientBackground.h>

void ClientWorkbenchServiceListener::onInstantiatedRenderArea(std::shared_ptr<RemoteViz::Rendering::RenderArea> renderArea)
{
  /// Instantiate the class overriding the renderAreaListener class behavior to manage the renderArea events.
  auto renderAreaListener = std::make_shared<ClientWorkbenchRenderAreaListener>();

  // Add the renderAreaListener instance as renderArea listener
  renderArea->addListener(renderAreaListener);

  // Instantiate a sceneExaminer to interact with the camera
  SceneExaminer* examiner = new SceneExaminer();

  // Add recognizers for gesture events
  renderArea->getTouchManager()->addDefaultRecognizers();

  // Scene graph
  SoInput i;
  i.openFile( "$OIVHOME/examples/data/RemoteViz/CAD/model.iv" ); // Load the iv file
  examiner->addChild(SoDB::readAll(&i));

  // Apply the sceneExaminer node as renderArea scene graph
  renderArea->getSceneManager()->setSceneGraph(examiner);

  // viewall
  examiner->viewAll(renderArea->getSceneManager()->getViewportRegion());
}
