#pragma once
#include <RemoteViz/Rendering/ServiceListener.h>
#include <RemoteViz/Rendering/RenderAreaListener.h>
#include <RemoteViz/Rendering/Client.h>
#include <RemoteViz/Rendering/ConnectionParameters.h>
#include <Inventor/ViewerComponents/nodes/SceneExaminer.h>

class ConnectionManagementServiceListener : public RemoteViz::Rendering::ServiceListener
{
public:

  bool signin(std::string &login, std::string& password);

  bool accept(std::shared_ptr<const RemoteViz::Rendering::ConnectionParameters> parameters);

  virtual bool onPendingCreateRenderArea(const std::string& renderAreaId, unsigned int& width, unsigned int& height, std::shared_ptr<RemoteViz::Rendering::RenderAreaHardware> renderAreaHardware, std::shared_ptr<RemoteViz::Rendering::Client> client, std::shared_ptr<const RemoteViz::Rendering::ConnectionParameters> parameters) override;

  virtual bool onPendingShareRenderArea(std::shared_ptr<RemoteViz::Rendering::RenderArea> renderArea, std::shared_ptr<RemoteViz::Rendering::Client> client, std::shared_ptr<const RemoteViz::Rendering::ConnectionParameters> parameters) override;

  virtual void onInstantiatedRenderArea(std::shared_ptr<RemoteViz::Rendering::RenderArea> renderArea) override;

};

