#include <FrontBackSyncRenderAreaListener.h>

#include <RemoteViz/Rendering/RenderArea.h>
#include <RemoteViz/Rendering/Connection.h>

#include <Inventor/SoSceneManager.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoSwitch.h>
#include <iomanip>
#include <Inventor/actions/SoCallbackAction.h>
#include <Inventor/actions/SoGetBoundingBoxAction.h>

#define LIMIT_SIZE 1000

void FrontBackSyncRenderAreaListener::setMatrix(SbMatrix m)
{
  m_mvp = m;
}

bool
FrontBackSyncRenderAreaListener::onPreRender( std::shared_ptr<RemoteViz::Rendering::RenderArea> renderArea, bool& clearWindow, bool& clearZbuffer )
{
  SoGetBoundingBoxAction cba(renderArea->getSceneManager()->getViewportRegion());
  cba.apply(renderArea->getSceneManager()->getSceneGraph());

  auto vp = renderArea->getSceneManager()->getViewportRegion();
  auto ws = vp.getWindowSize();

  std::ostringstream streamObj;
  streamObj << std::fixed << std::setprecision( 8 );
  streamObj << "mat "   << ( m_mvp )[0][0] << " "
                        << ( m_mvp )[0][1] << " "
                        << ( m_mvp )[0][2] << " "
                        << ( m_mvp )[0][3] << " "
                        << ( m_mvp )[1][0] << " "
                        << ( m_mvp )[1][1] << " "
                        << ( m_mvp )[1][2] << " "
                        << ( m_mvp )[1][3] << " "
                        << ( m_mvp )[2][0] << " "
                        << ( m_mvp )[2][1] << " "
                        << ( m_mvp )[2][2] << " "
                        << ( m_mvp )[2][3] << " "
                        << ( m_mvp )[3][0] << " "
                        << ( m_mvp )[3][1] << " "
                        << ( m_mvp )[3][2] << " "
                        << ( m_mvp )[3][3] << " "
                        << ws[0] << " "
                        << ws[1];

  std::string message = streamObj.str();
  renderArea->setFrameMessage(message);

  return true;
}

//------------------------------------------------------------------------------
void
FrontBackSyncRenderAreaListener::onSendingFrame( std::shared_ptr<RemoteViz::Rendering::RenderArea> renderArea,
                                    std::shared_ptr<RemoteViz::Rendering::Connection> sender,
                                    std::string& message )
{
  message = sender->getLastEncodedFrame().getMessage();
}
