#include <FrontBackSyncServiceListener.h>

#include <RemoteViz/Rendering/RenderArea.h>
#include <RemoteViz/Rendering/ConnectionParameters.h>

#include <Inventor/SoSceneManager.h>
#include <Inventor/touch/SoTouchManager.h>
#include <Inventor/nodes/SoAlgebraicCone.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoGradientBackground.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoTexture2.h>
#include <Inventor/nodes/SoIndexedTriangleSet.h>
#include <Inventor/nodes/SoCallback.h>
#include <Inventor/actions/SoGLRenderAction.h>
#include <Inventor/actions/SoHandleEventAction.h>
#include <Inventor/actions/SoCallbackAction.h>
#include <Inventor/actions/SoGetBoundingBoxAction.h>
#include <Inventor/elements/SoModelMatrixElement.h>
#include <Inventor/elements/SoViewingMatrixElement.h>
#include <Inventor/elements/SoProjectionMatrixElement.h>
#include <Inventor/elements/SoSwitchElement.h>
#include <Inventor/nodes/SoTransform.h>
#include <Inventor/nodes/SoAnnoText3.h>
#include <Inventor/nodes/SoAnnotation.h>
#include <Inventor/nodes/SoAnnoText3Property.h>


//------------------------------------------------------------------------------
void
FrontBackSyncServiceListener::callback( void* data, SoAction* action )
{
  if ( action->isOfType( SoGetBoundingBoxAction::getClassTypeId() ) )
  {
    FrontBackSyncRenderAreaListener* sfsl = static_cast<FrontBackSyncRenderAreaListener*>( data );
    SoState* state = action->getState();
    sfsl->setMatrix(SbMatrix( SoModelMatrixElement::get( state ) * SoViewingMatrixElement::get( state ) * SoProjectionMatrixElement::get( state ) ));
  }
}

//------------------------------------------------------------------------------
void FrontBackSyncServiceListener::onInstantiatedRenderArea(std::shared_ptr<RemoteViz::Rendering::RenderArea> renderArea)
{
  // Instantiate the class overriding the renderAreaListener class behavior to manage the renderArea events.
  std::shared_ptr<FrontBackSyncRenderAreaListener> renderAreaListener = std::make_shared<FrontBackSyncRenderAreaListener>();

  // Add the renderAreaListener instance as renderArea listener
  renderArea->addListener(renderAreaListener);

  // Instantiate a sceneExaminer to interact with the camera
  SceneExaminer* examiner = new SceneExaminer();
  examiner->setNavigationMode(SceneExaminer::ORBIT);
  examiner->setCameraMode(SceneInteractor::ORTHOGRAPHIC);

  // Add recognizers for gesture events
  renderArea->getTouchManager()->addDefaultRecognizers();

  /* Scene graph*/
  SoAlgebraicCone* cone = new SoAlgebraicCone();
  examiner->addChild( cone );

  SoTransform* transform = new SoTransform();
  transform->translation = SbVec3f( -0.5f, -1.3f, 0.f );
  
  SoAnnoText3Property* annoText3Property = new SoAnnoText3Property;
  annoText3Property->renderPrintType = SoAnnoText3Property::RENDER2D_PRINT_RASTER;

  SoMaterial* mat = new SoMaterial;
  mat->diffuseColor = SbColor(0.98f, 0.68f, 0.27f);
  
  SoCallback* callbackNode = new SoCallback();
  callbackNode->setCallback( &FrontBackSyncServiceListener::callback, renderAreaListener.get() );
  examiner->addChild( callbackNode );

  SoFont* font = new SoFont();
  font->size = 0.2f;
  font->name = "Arial";

  SoAnnoText3* textBack = new SoAnnoText3;
  textBack->string.set1Value( 0, "Cone drawn" );
  textBack->string.set1Value( 1, "on backend" );
 
  SoAnnotation* legendAnnot = new SoAnnotation ;
 
  examiner->addChild( transform );
  examiner->addChild( legendAnnot );
  legendAnnot->addChild( annoText3Property );
  legendAnnot->addChild( mat );
  legendAnnot->addChild( font );
  legendAnnot->addChild( textBack );

  // Apply the sceneExaminer node as renderArea scene graph
  renderArea->getSceneManager()->setSceneGraph(examiner);

  // viewall
  examiner->viewAll(renderArea->getSceneManager()->getViewportRegion());
}
