#include <HelloConeH264RenderAreaListener.h>

#include <RemoteViz/Rendering/Connection.h>
#include <RemoteViz/Rendering/FrameEncoders.h>

//--------------------------------------------------------------------------------
void HelloConeH264RenderAreaListener::onOpenedConnection(std::shared_ptr<RemoteViz::Rendering::RenderArea>, std::shared_ptr<RemoteViz::Rendering::Connection>, std::shared_ptr<RemoteViz::Rendering::FrameEncoders> frameEncoders)
{
  // Set H264 NVENC as frame encoder for this connection. It requires an NVIDIA GPU Kepler or higher and CUDA Toolkit 10.1 or higher.
  frameEncoders->setInteractiveEncoder( RemoteViz::Rendering::FrameEncoders::H264_NVENC );
  frameEncoders->setStillEncoder( RemoteViz::Rendering::FrameEncoders::H264_NVENC );
}

//--------------------------------------------------------------------------------
void HelloConeH264RenderAreaListener::onInitializedConnection(std::shared_ptr<RemoteViz::Rendering::RenderArea>, std::shared_ptr<RemoteViz::Rendering::Connection>, std::shared_ptr<const RemoteViz::Rendering::FrameEncoders> frameEncoders)
{
  // The connection and the frame encoder have been initialized successfully.
  if ( frameEncoders->getInteractiveEncoder() == RemoteViz::Rendering::FrameEncoders::JPEG &&
        frameEncoders->getStillEncoder() == RemoteViz::Rendering::FrameEncoders::JPEG )
  {
    std::cout << "New connection using JPEG encoder for interactive and still frames."<< std::endl;
  }
  else if ( frameEncoders->getInteractiveEncoder() == RemoteViz::Rendering::FrameEncoders::JPEG &&
        frameEncoders->getStillEncoder() == RemoteViz::Rendering::FrameEncoders::PNG )
  {
    std::cout << "New connection using JPEG encoder for interactive frames and PNG encoder for still frames."<< std::endl;
  }
  else if ( frameEncoders->getInteractiveEncoder() == RemoteViz::Rendering::FrameEncoders::H264_NVENC &&
        frameEncoders->getStillEncoder() == RemoteViz::Rendering::FrameEncoders::H264_NVENC )
  {
    std::cout << "New connection using NVENC H264 encoder (GPU encoding) for interactive and still frames."<< std::endl;
  }
  else if ( frameEncoders->getInteractiveEncoder() == RemoteViz::Rendering::FrameEncoders::H264_OPENH264 &&
        frameEncoders->getStillEncoder() == RemoteViz::Rendering::FrameEncoders::H264_OPENH264 )
  {
    std::cout << "New connection using OpenH264 encoder (CPU encoding) for interactive and still frames."<< std::endl;
  }
  else
  {
    std::cout << "New connection." << std::endl;
  }
  
}

//--------------------------------------------------------------------------------
void HelloConeH264RenderAreaListener::onRefusedEncoder(std::shared_ptr<RemoteViz::Rendering::RenderArea>, std::shared_ptr<RemoteViz::Rendering::Connection> connection, std::shared_ptr<RemoteViz::Rendering::FrameEncoders> frameEncoders)
{
  // At least one of the frame encoders cannot be initialized, set others encoders.
  if ( frameEncoders->getInteractiveEncoder() == RemoteViz::Rendering::FrameEncoders::H264_NVENC &&
       frameEncoders->getStillEncoder() == RemoteViz::Rendering::FrameEncoders::H264_NVENC )
  {
    frameEncoders->setInteractiveEncoder( RemoteViz::Rendering::FrameEncoders::H264_OPENH264 );
    frameEncoders->setStillEncoder( RemoteViz::Rendering::FrameEncoders::H264_OPENH264 );
  }
  else if ( frameEncoders->getInteractiveEncoder() == RemoteViz::Rendering::FrameEncoders::H264_OPENH264 &&
       frameEncoders->getStillEncoder() == RemoteViz::Rendering::FrameEncoders::H264_OPENH264 )
  {
    frameEncoders->setInteractiveEncoder( RemoteViz::Rendering::FrameEncoders::JPEG );
    frameEncoders->setStillEncoder( RemoteViz::Rendering::FrameEncoders::PNG );
  }
  else if ( frameEncoders->getInteractiveEncoder() == RemoteViz::Rendering::FrameEncoders::JPEG &&
            frameEncoders->getStillEncoder() == RemoteViz::Rendering::FrameEncoders::PNG )
  {
    frameEncoders->setInteractiveEncoder( RemoteViz::Rendering::FrameEncoders::JPEG );
    frameEncoders->setStillEncoder( RemoteViz::Rendering::FrameEncoders::JPEG );
  }
  else if ( frameEncoders->getInteractiveEncoder() == RemoteViz::Rendering::FrameEncoders::JPEG &&
            frameEncoders->getStillEncoder() == RemoteViz::Rendering::FrameEncoders::JPEG )
  {
    std::cout << "Error: RemoteViz codec libraries are missing." << std::endl;
    connection->close();
  }
  else
  {
    frameEncoders->setInteractiveEncoder( RemoteViz::Rendering::FrameEncoders::JPEG );
    frameEncoders->setStillEncoder( RemoteViz::Rendering::FrameEncoders::JPEG );
  }
}


