#include <HelloConeVP9RenderAreaListener.h>

#include <RemoteViz/Rendering/Connection.h>
#include <RemoteViz/Rendering/FrameEncoders.h>

//--------------------------------------------------------------------------------
void HelloConeVP9RenderAreaListener::onOpenedConnection(std::shared_ptr<RemoteViz::Rendering::RenderArea>, std::shared_ptr<RemoteViz::Rendering::Connection>, std::shared_ptr<RemoteViz::Rendering::FrameEncoders> frameEncoders)
{
  // Set VP9 as frame encoder for this connection.
  frameEncoders->setInteractiveEncoder( RemoteViz::Rendering::FrameEncoders::VP9_VPX );
  frameEncoders->setStillEncoder( RemoteViz::Rendering::FrameEncoders::VP9_VPX );
}

//--------------------------------------------------------------------------------
void HelloConeVP9RenderAreaListener::onInitializedConnection(std::shared_ptr<RemoteViz::Rendering::RenderArea>, std::shared_ptr<RemoteViz::Rendering::Connection>, std::shared_ptr<const RemoteViz::Rendering::FrameEncoders> frameEncoders)
{
  // The connection and the frame encoder have been initialized successfully.
  if ( frameEncoders->getInteractiveEncoder() == RemoteViz::Rendering::FrameEncoders::JPEG &&
        frameEncoders->getStillEncoder() == RemoteViz::Rendering::FrameEncoders::JPEG )
  {
    std::cout << "New connection using JPEG encoder for interactive and still frames."<< std::endl;
  }
  else if ( frameEncoders->getInteractiveEncoder() == RemoteViz::Rendering::FrameEncoders::JPEG &&
        frameEncoders->getStillEncoder() == RemoteViz::Rendering::FrameEncoders::PNG )
  {
    std::cout << "New connection using JPEG encoder for interactive frames and PNG encoder for still frames."<< std::endl;
  }
  else if ( frameEncoders->getInteractiveEncoder() == RemoteViz::Rendering::FrameEncoders::VP9_VPX &&
        frameEncoders->getStillEncoder() == RemoteViz::Rendering::FrameEncoders::VP9_VPX )
  {
    std::cout << "New connection using VPX encoder (CPU encoding) for interactive and still frames."<< std::endl;
  }
  else
  {
    std::cout << "New connection." << std::endl;
  }
  
}

//--------------------------------------------------------------------------------
void HelloConeVP9RenderAreaListener::onRefusedEncoder(std::shared_ptr<RemoteViz::Rendering::RenderArea>, std::shared_ptr<RemoteViz::Rendering::Connection> connection, std::shared_ptr<RemoteViz::Rendering::FrameEncoders> frameEncoders)
{
  // At least one of the frame encoders cannot be initialized, set others encoders.
  if ( frameEncoders->getInteractiveEncoder() == RemoteViz::Rendering::FrameEncoders::VP9_VPX &&
       frameEncoders->getStillEncoder() == RemoteViz::Rendering::FrameEncoders::VP9_VPX )
  {
    frameEncoders->setInteractiveEncoder( RemoteViz::Rendering::FrameEncoders::JPEG );
    frameEncoders->setStillEncoder( RemoteViz::Rendering::FrameEncoders::PNG );
  }
  else if ( frameEncoders->getInteractiveEncoder() == RemoteViz::Rendering::FrameEncoders::JPEG &&
            frameEncoders->getStillEncoder() == RemoteViz::Rendering::FrameEncoders::PNG )
  {
    frameEncoders->setInteractiveEncoder( RemoteViz::Rendering::FrameEncoders::JPEG );
    frameEncoders->setStillEncoder( RemoteViz::Rendering::FrameEncoders::JPEG );
  }
  else if ( frameEncoders->getInteractiveEncoder() == RemoteViz::Rendering::FrameEncoders::JPEG &&
            frameEncoders->getStillEncoder() == RemoteViz::Rendering::FrameEncoders::JPEG )
  {
    std::cout << "Error: RemoteViz codec libraries are missing." << std::endl;
    connection->close();
  }
  else
  {
    frameEncoders->setInteractiveEncoder( RemoteViz::Rendering::FrameEncoders::JPEG );
    frameEncoders->setStillEncoder( RemoteViz::Rendering::FrameEncoders::JPEG );
  }
}


