#pragma once

#include <Inventor/events/SoMouseButtonEvent.h>

#include <mutex>

/**
*  Render engine
*/
class Engine
{
public:

  struct Frame
  {
    unsigned char* pixels;
    bool isInteractive;
    size_t id;
  };

  /**
  *  Constructor
  */
  Engine(unsigned int width, unsigned int height);

  /**
  *  Destructor
  */
  ~Engine();

  /**
  * Resize the render engine
  */
  void resize(unsigned int width, unsigned int height);

  /**
  *  Returns frame
  */
  const Frame& getFrame() const;

  /**
  *  Returns frame mutex
  */
  std::mutex& getFrameMutex() const;

  /**
  *  Process a MouseUp event.
  */
  bool mouseUp(int x, int y, SoMouseButtonEvent::Button button);

  /**
  *  Process a MouseDown event.
  */
  bool mouseDown(int x, int y, SoMouseButtonEvent::Button button);

  /**
  *  Process a MouseMove event.
  */
  bool mouseMove(int x, int y);

private:

  /**
  * Displays something
  */
  void display(bool interactiveFrame);

  /**
  *  Left button state
  */
  bool m_isButton0Down;
  bool m_isTouchDown;

  /**
  *  Mouse position
  */
  int m_mouseX;
  int m_mouseY;

private:
  unsigned int m_width;
  unsigned int m_height;
  Frame m_frame;
  mutable std::mutex m_frameMutex;
};
