#pragma once

#include <RemoteViz/Rendering/RenderAreaListener.h>

class LoadBalancedRenderAreaListener : public RemoteViz::Rendering::RenderAreaListener
{
public:
  /*!
  *
  *  Triggered when the connection and the frame encoder are initialized successfully.\n
  *
  *  \param renderArea : pointer to the RenderArea
  *
  *  \param sender : pointer to the connection
  *
  *  \param frameEncoders : frame encoders that have been initialized by the connection
  */
  virtual void onInitializedConnection(std::shared_ptr<RemoteViz::Rendering::RenderArea> renderArea, std::shared_ptr<RemoteViz::Rendering::Connection> sender, std::shared_ptr<const RemoteViz::Rendering::FrameEncoders> frameEncoders ) override;
};

