// Web Server serving static files over HTTP

var express = require('express'),
    app = express(),
    http = require('http'),
    log4js = require('log4js');

http.Server(app);

app.use(express.static(__dirname + '/../Clients/HTML5'));

app.get('/', function (req, res) {
    res.sendFile(__dirname + '/../Clients/HTML5/index.html');
});

// Load configuration file that stores IP address and port number.
const config = require('./config/config.json');
const webServerConfig = config.webserver;

// Logger
const logger = log4js.getLogger();
logger.level = 'debug';

app.listen(webServerConfig.port, webServerConfig.ip, () => {
    logger.info(`Web server running at http://${webServerConfig.ip}:${webServerConfig.port}/`);
});
