#include <RemoteViz/Clients/nodes/RemoteVizClient.h>
#include <RemoteViz/Clients/nodes/SoRemoteVizClient.h>

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/SoXtRenderArea.h>

void onServiceMessage(SoRemoteVizClient::ServiceMessageEventArg& arg)
{
  if ( arg.getState() == SoRemoteVizClient::ServiceMessageEventArg::CONNECTED )
  {
    SoDebugError::postInfo("RemoteVizClientNode", "Connected.");
  }
  else if ( arg.getState() == SoRemoteVizClient::ServiceMessageEventArg::DISCONNECTED )
  {
    SoDebugError::postInfo("RemoteVizClientNode", "Disconnected.");
  }
  else if ( arg.getState() == SoRemoteVizClient::ServiceMessageEventArg::START_NETWORK_CALIBRATION )
  {
    SoDebugError::postInfo("RemoteVizClientNode", "Start network calibration, please wait...");
  }
  else if (arg.getState() == SoRemoteVizClient::ServiceMessageEventArg::PENDING_NETWORK_CALIBRATION)
  {
    SoDebugError::postInfo("RemoteVizClientNode", "Network calibration is pending, please wait...");
  }
  else if ( arg.getState() == SoRemoteVizClient::ServiceMessageEventArg::FINISH_NETWORK_CALIBRATION )
  {
    SoDebugError::postInfo("RemoteVizClientNode", "Network calibration finished.");
  }
  else if (arg.getState() == SoRemoteVizClient::ServiceMessageEventArg::START_BANDWIDTH_CALIBRATION)
  {
    SoDebugError::postInfo( "RemoteVizClientNode", "Start network bandwidth calibration, please wait..." );
  }
  else if (arg.getState() == SoRemoteVizClient::ServiceMessageEventArg::FINISH_BANDWIDTH_CALIBRATION)
  {
    SoDebugError::postInfo( "RemoteVizClientNode", "Network bandwidth calibration finished." );
  }
  else if (arg.getState() == SoRemoteVizClient::ServiceMessageEventArg::START_LATENCY_CALIBRATION)
  {
    SoDebugError::postInfo( "RemoteVizClientNode", "Start network latency calibration, please wait..." );
  }
  else if (arg.getState() == SoRemoteVizClient::ServiceMessageEventArg::FINISH_LATENCY_CALIBRATION)
  {
    SoDebugError::postInfo( "RemoteVizClientNode", "Network latency calibration finished." );
  }
}

int main(int /*argc*/, char** /*argv*/)
{
  Widget myWindow = SoXt::init("RemoteVizClientNode"); // pass the app name
  if (myWindow == NULL)
    return 1;

  // Initialize RemoteVizClient node
  RemoteVizClient::init();

  // Create the scene graph
  SoRef<SoRemoteVizClient> root = new SoRemoteVizClient();
  root->ipAddress = "127.0.0.1";
  root->port = 8080;
  root->onServiceMessage.add(onServiceMessage); // Add a callback to display connection informations
  root->connect = TRUE; // Start the connection

  // Create a renderArea in which to see our scene graph.
  // The render area will appear within the main window.
  SoXtRenderArea *myRenderArea = new SoXtRenderArea(myWindow);

  // Put our scene in myRenderArea, change the title
  myRenderArea->setSceneGraph(root.ptr());
  myRenderArea->setTitle("RemoteVizClientNode");
  myRenderArea->show();

  SoXt::show(myWindow);  // Display main window
  SoXt::mainLoop();      // Main Inventor event loop

  delete myRenderArea;

  RemoteVizClient::finish();
  SoXt::finish();

  return 0;
}

