#include <RemoteViz/Clients/nodes/RemoteVizClient.h>
#include <RemoteViz/Clients/nodes/SoRemoteVizClient.h>
#include <Inventor/nodes/SoSeparator.h>
#include <DialogViz/dialog/SoTopLevelDialog.h>
#include <DialogViz/dialog/SoDialogCustom.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/SoXtRenderArea.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/drawers/SoLassoScreenDrawer.h>
#include <Inventor/actions/SoHandleEventAction.h>
#include <Inventor/nodes/SoSwitch.h>
#include <DialogViz/SoDialogVizAll.h>

void onServiceMessage(SoRemoteVizClient::ServiceMessageEventArg& arg)
{
  if ( arg.getState() == SoRemoteVizClient::ServiceMessageEventArg::CONNECTED )
  {
    SoDebugError::postInfo("RemoteVizClientNode", "Connected.");
  }
  else if ( arg.getState() == SoRemoteVizClient::ServiceMessageEventArg::DISCONNECTED )
  {
    SoDebugError::postInfo("RemoteVizClientNode", "Disconnected.");
  }
  else if ( arg.getState() == SoRemoteVizClient::ServiceMessageEventArg::START_NETWORK_CALIBRATION )
  {
    SoDebugError::postInfo("RemoteVizClientNode", "Start network calibration, please wait...");
  }
  else if (arg.getState() == SoRemoteVizClient::ServiceMessageEventArg::PENDING_NETWORK_CALIBRATION)
  {
    SoDebugError::postInfo("RemoteVizClientNode", "Network calibration is pending, please wait...");
  }
  else if ( arg.getState() == SoRemoteVizClient::ServiceMessageEventArg::FINISH_NETWORK_CALIBRATION )
  {
    SoDebugError::postInfo("RemoteVizClientNode", "Network calibration finished.");
  }
}

static SoSeparator* s_root;

// Auditor for the radio button
class ActiveElementAuditor : public SoDialogChoiceAuditor {
  void dialogChoice( SoDialogChoice * cpt )
  {
    int32_t selectedShapeItem = cpt->selectedItem.getValue();
    switch ( selectedShapeItem ) {
    case 0:
      // Move RemoteVizClient node to be after screen drawer
      s_root->addChild( s_root->getChild( 0 ) );
      s_root->removeChild( 0 );
      break;
    case 1:
      // Move screen drawer to be after RemoteVizClient
      s_root->addChild( s_root->getChild( 0 ) );
      s_root->removeChild( 0 );
      break;
    }
  }
};/*---------------------------------------------------------------------------*/

int main(int /*argc*/, char** /*argv*/)
{
  Widget myWindow = SoXt::init("RemoteVizClientNode"); // pass the app name
  if (myWindow == NULL)
    return 1;

  // initialize some classes
  RemoteVizClient::init();
  SoDialogViz::init();

  // Build dialog
  SoRef<SoTopLevelDialog> myTop = new SoTopLevelDialog();
  myTop->label =  "RemoteVizScreenDrawer" ;
  myTop->position.setValue(0,0);

  // 
  SoDialogCustom* myCustom = new SoDialogCustom;
  myCustom->width = 600;
  myCustom->height = 400;
  myTop->addChild(myCustom);

  // Add custom gui container
  SoColumnDialog* guiContainer = new SoColumnDialog();
  guiContainer->fixedHeight = TRUE;
  myTop->addChild(guiContainer);

  // Radio button to select which node catch user events
  SoDialogRadioButtons* catchEventRadio = new SoDialogRadioButtons;
  catchEventRadio->auditorID = "CATCH_EVENT_ID";
  catchEventRadio->label = "Active element";
  catchEventRadio->items.set1Value(0, "Screen Drawer");
  catchEventRadio->items.set1Value(1, "RenderArea");
  catchEventRadio->minWidth = 120;
  catchEventRadio->addAuditor( new ActiveElementAuditor() );

  guiContainer->addChild(catchEventRadio);

  myTop->buildDialog(myWindow, TRUE);
  myTop->show();

  // Create viewer
  SoXtRenderArea* myViewer = new SoXtRenderArea(myCustom->getWidget());
  myViewer->setTransparencyType(SoGLRenderAction::OPAQUE_FIRST);
  myViewer->setFastEditSavePolicy(SoGLRenderAction::WHEN_NEEDED);

  // Create static nodes
  SoRef<SoSeparator> root = new SoSeparator;
  s_root = root.ptr();

  // Create drawer
  SoLassoScreenDrawer* drawer = new SoLassoScreenDrawer();
  s_root->addChild( drawer );

  // Add remoteviz node
  SoRemoteVizClient* remoteViz = new SoRemoteVizClient();
  remoteViz->ipAddress = "127.0.0.1";
  remoteViz->port = 8080;
  remoteViz->onServiceMessage.add(onServiceMessage); // Add a callback to display connection informations
  remoteViz->connect = TRUE; // Start the connection
  s_root->addChild(remoteViz);

  myViewer->setSceneGraph(root.ptr());
  myViewer->show();

  SoXt::show(myWindow);  // Display main window
  SoXt::mainLoop();      // Main Inventor event loop
  
  // Remove pointers
  root = NULL;
  myTop = NULL;
  delete myViewer;

  // Release classes
  RemoteVizClient::finish();
  SoDialogViz::finish();
  SoXt::finish();

  return 0;
}

