#include <SecureConnectionServiceListener.h>

#include <RemoteViz/Rendering/RenderArea.h>
#include <Inventor/SoSceneManager.h>
#include <Inventor/touch/SoTouchManager.h>
#include <Inventor/nodes/SoCone.h>
#include <Inventor/nodes/SoGradientBackground.h>

#include <Inventor/ViewerComponents/nodes/SceneExaminer.h>

//--------------------------------------------------------------------------------
void SecureConnectionServiceListener::onInstantiatedRenderArea(std::shared_ptr<RemoteViz::Rendering::RenderArea> renderArea)
{
  // Instantiate a renderAreaListener class to manage the renderArea events (default behaviors).
  auto renderAreaListener = std::make_shared<RemoteViz::Rendering::RenderAreaListener>();

  // Add the renderAreaListener instance as renderArea listener
  renderArea->addListener(renderAreaListener);

  // Instantiate a sceneExaminer to interact with the camera
  SceneExaminer *examiner = new SceneExaminer();

  // Add recognizers for gesture events
  renderArea->getTouchManager()->addDefaultRecognizers();

  // Scene graph
  examiner->addChild(new SoCone());
  examiner->addChild(new SoGradientBackground());

  // Apply the sceneExaminer node as renderArea scene graph
  renderArea->getSceneManager()->setSceneGraph(examiner);

  // viewall
  examiner->viewAll(renderArea->getSceneManager()->getViewportRegion());
}

//--------------------------------------------------------------------------------
std::string SecureConnectionServiceListener::onRequestedPrivateKeyPassphrase()
{
  // The provided private key does not contain a passphrase.
  return std::string("");
}
