#ifndef UTILS_H
#define UTILS_H

#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/actions/SoSearchAction.h>
#include <DialogViz/SoDialogVizAll.h>

extern SoSeparator *readFile(const char *filename);
extern Widget buildInterface(Widget window, const char *filename, const char* viewer,
                             SoTopLevelDialog** myTopLevelDialog);

template<typename T>
T*
searchNode(SoNode* scene)
{
  SoSearchAction* sa = new SoSearchAction;
  sa->setType(T::getClassTypeId());
  sa->apply(scene);

  SoPath* path = sa->getPath();
  if ( !path )
  {
    std::cerr << T::getClassTypeId().getName().getString() << " not found" << std::endl;
    exit(0);
  }

  return dynamic_cast<T*>(path->getTail());
}

// search a node by name
template<typename T>
T* 
searchName(SoNode* scene, SbName name)
{
  if (!scene)
  {
    T* node=(T*)SoNode::getByName(name);
    if ( node )
      return node;
  }
  else
  {
    SoSearchAction* sa = new SoSearchAction;
    sa->setFind(SoSearchAction::NAME);
    sa->setSearchingAll(true);
    sa->setType(T::getClassTypeId());
    sa->setName(name);
    sa->apply(scene);

    SoPath* path = sa->getPath();
    if ( path )
      return dynamic_cast<T*>(path->getTail());
  }

  std::cerr << T::getClassTypeId().getName().getString() << " not found" << std::endl;
  return(NULL);
}

#endif


