/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2019 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Federico Gamba (Nov 2009)
**=======================================================================*/

#include "GuiDialogViz.h"
#include "OivSceneGraph.h"
#include "AuditorVisualization.h"

#include <DialogViz/auditors/SoDialogAuditor.h> 
#include <DialogViz/dialog/SoDialogRealSlider.h>
#include <DialogViz/dialog/SoDialogIntegerSlider.h>
#include <DialogViz/dialog/SoDialogCheckBox.h>
#include <DialogViz/dialog/SoTopLevelDialog.h>
#include <DialogViz/dialog/SoDialogComboBox.h>

//---------------------------------------------------------------------------
void 
AuditorVisualization::dialogRealSlider (SoDialogRealSlider* slider)
{
  SbString auditorId = slider->auditorID.getValue();
  if (auditorId == "planeslicerot")
//    m_sceneGraph->rotateGeomSlice(slider->value.getValue());
		;
  else if (auditorId == "zscale")
	  m_sceneGraph->getTransform()->scaleFactor.setValue(slider->value.getValue(),1, 1);
}

void 
AuditorVisualization::dialogIntegerSlider (SoDialogIntegerSlider* slider)
{
  SbString auditorId = slider->auditorID.getValue();
  int sliceId=-1;
  if (auditorId == "slicenumber0")
    sliceId=0;
  else if (auditorId == "slicenumber1")
    sliceId=1;
  else if (auditorId == "slicenumber2")
    sliceId=2;

  if (sliceId>=0) {
	SoOrthoSlice* app = (SoOrthoSlice*)(m_sceneGraph->getSlice(sliceId));
	app->sliceNumber.setValue(slider->value.getValue());
	app->touch();
  }
}

void 
AuditorVisualization::dialogComboBox(SoDialogComboBox* component)
{
  SbString auditorId = component->auditorID.getValue();
  if (auditorId == "colormap") {
	
  }
}

