/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Federico Gamba (Nov 2009)
**=======================================================================*/

#ifndef _AuditorVisualization_H_
#define _AuditorVisualization_H_

#include "GuiDialogViz.h"
#include "OivSceneGraph.h"

#include <DialogViz/auditors/SoDialogAuditor.h> 
class SoDialogRealSlider;
class SoDialogIntegerSlider;
class SoDialogComboBox;

class AuditorVisualization : public SoDialogAuditor 
{
public:
  AuditorVisualization(GuiDialogViz* gui) 
    : m_gui(gui)
  {
    m_sceneGraph = gui->getSceneGraph();
  }

  void dialogRealSlider (SoDialogRealSlider* slider);
  void dialogIntegerSlider (SoDialogIntegerSlider* slider);
  void dialogComboBox(SoDialogComboBox* component);

private:
  OivSceneGraph* m_sceneGraph;
  GuiDialogViz*  m_gui;
};

#endif


