/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Federico Gamba (Nov 2009)
**=======================================================================*/

#include <stdio.h>
#include <math.h>
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSeparator.h>
#include <DialogViz/dialog/SoDialogViz.h>



#define LDM_FILENAME "$OIVHOME/examples/data/VolumeViz/COLT.VOL"
#define GUI_FILENAME "$OIVHOME/examples/source/VolumeViz/Compute/ComputeHistogram/ComputeHistogram.iv"

#include "OivSceneGraph.h"
#include "GuiDialogViz.h"

#include <Inventor/SoWinApp.h>
int
main(int, char **argv)
{
  // Initialize Inventor and Xt
  Widget myWindow = SoXt::init(argv[0]) ;
  if (myWindow == NULL) exit(1) ;
  
  SoDialogViz::init();
  SoVolumeRendering::init();
  PoMeshViz::init() ;

  OivSceneGraph* sceneGraph = new OivSceneGraph(LDM_FILENAME);
  GuiDialogViz* dialogViz = new GuiDialogViz(GUI_FILENAME,myWindow,sceneGraph);
  sceneGraph->setGui(dialogViz);
  dialogViz->updateGui();

  SoSeparator* root = sceneGraph->getRoot();
  Widget parent = dialogViz->getWidget();


  SoXtExaminerViewer *myViewer = new SoXtExaminerViewer(parent);  

  myViewer->setSceneGraph(root);
#ifdef USE_POSCENEVIEW
  SoBaseKit::setSearchingChildren(TRUE);
  myViewer->setCamera(sceneGraph->get3DCamera());
#endif
  myViewer->show();

  myViewer->viewAll();
  SoXt::show(myWindow);
  SoXt::mainLoop();

  delete myViewer;
  root->unref();
  PoMeshViz::finish() ;
  SoVolumeRendering::finish();
  SoDialogViz::finish();
  SoXt::finish();
  return 0;
}


