#include "GuiDialogViz.h"
#include "OivSceneGraph.h"
#include "AuditorCheckSwitch.h"
#include "AuditorVisualization.h"

#include <DialogViz/SoDialogVizAll.h>
#include <Inventor/nodes/SoGroup.h>

#include <Inventor/STL/sstream>
//---------------------------------------------------------------------------
GuiDialogViz::GuiDialogViz(std::string ivDialogFile, Widget window, OivSceneGraph* sceneGraph) :
  m_sceneGraph(sceneGraph),
  m_ivDialogFile(ivDialogFile)
{
  m_LdmDim = sceneGraph->getLdmDim();
  m_widget = buildGui(window);

}

//---------------------------------------------------------------------------
Widget
GuiDialogViz::buildGui(Widget window)
{
  SoInput myInput;
  if (! myInput.openFile( m_ivDialogFile.c_str() ))
    return NULL;
  SoGroup *myGroup = SoDB::readAll( &myInput );
  if (! myGroup)
    return NULL;
  m_topLevelDialog = (SoTopLevelDialog *)myGroup->getChild( 0 );

  SoDialogCustom *customNode = (SoDialogCustom *)m_topLevelDialog->searchForAuditorId("Viewer");

  initVisualizationPanel();
  initComputePanel();
  initLDMPanel();

  m_topLevelDialog->buildDialog( window, customNode != NULL );
  m_topLevelDialog->show();

  m_widget = customNode ? customNode->getWidget() : window;

  return m_widget;
}

void 
GuiDialogViz::initComputePanel()
{
//  SoDialogGroup* computeTab = (SoDialogGroup *)m_topLevelDialog->searchForAuditorId("computetab");
//  if (computeTab != NULL)
//    computeTab->addAuditor(new AuditorCompute(this));
}

void 
GuiDialogViz::initLDMPanel()
{
//  SoDialogGroup* LDMTab = (SoDialogGroup *)m_topLevelDialog->searchForAuditorId("ldmtab");
//  if (LDMTab != NULL)
//    LDMTab->addAuditor(new AuditorLDM(this));
}
 
void 
GuiDialogViz::initVisualizationPanel()
{
  SoDialogGroup* visualizationTab = (SoDialogGroup *)m_topLevelDialog->searchForAuditorId("viztab");
  if (visualizationTab != NULL)
    visualizationTab->addAuditor(new AuditorVisualization(this));

  for (int i=0;i<NUM_SLICE;i++) {
	buildAuditorSlice(i);
  }
	
  // zscale
  std::ostringstream appId;
  appId << "zscale";
  SoDialogRealSlider* ZScaleSlider = (SoDialogRealSlider*)m_topLevelDialog->searchForAuditorId(appId.str().c_str());
  if (ZScaleSlider!=NULL)
	m_sceneGraph->getTransform()->scaleFactor.setValue(ZScaleSlider->value.getValue(),1, 1);

}

void 
GuiDialogViz::updateGui() 
{
   for (int id=0;id<NUM_SLICE;id++) {
		std::ostringstream numberId;
		numberId << "slicenumber" << id;
		SoDialogIntegerSlider* sliceNumberDialog  = (SoDialogIntegerSlider*)m_topLevelDialog->searchForAuditorId(numberId.str().c_str());
		if (sliceNumberDialog != NULL) {
		  sliceNumberDialog->max =  m_LdmDim[id]-1;

		  SoOrthoSlice* Slice = (SoOrthoSlice*)(m_sceneGraph->getSlice(id));
		  Slice->sliceNumber.setValue(sliceNumberDialog->value.getValue());
		  Slice->touch();
		}
   }
}

void 
GuiDialogViz::buildAuditorSlice(int id)
{

  SoSwitch* switchSlice = m_sceneGraph->getSwitchSlice(id);

  // slice check 
  std::ostringstream checkId;
  checkId << "slicecheck" << id;
  SoDialogCheckBox* sliceCheck = (SoDialogCheckBox *)m_topLevelDialog->searchForAuditorId(checkId.str().c_str());
  if (sliceCheck != NULL)
  {
    AuditorCheckSwitch* auditorCheckSwitch = new AuditorCheckSwitch(switchSlice);
    sliceCheck->addAuditor(auditorCheckSwitch);
    // call callback to update the switch of this slice
    auditorCheckSwitch->dialogCheckBox(sliceCheck);
  }

}


