/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Federico Gamba (Nov 2009)
**=======================================================================*/

#ifndef _GUIDIALOGVIZ_H
#define _GUIDIALOGVIZ_H

#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>

#include <Inventor/STL/string>
#include <Inventor/STL/vector>
#include <Inventor/SbVec.h>

class SoTopLevelDialog;
class SoDialogComboBox;
class OivSceneGraph;

class GuiDialogViz
{
public:
  GuiDialogViz(std::string ivDialogFile, Widget window, OivSceneGraph* sceneGraph);

  inline void setSceneGraph(OivSceneGraph* sceneGraph) {m_sceneGraph = sceneGraph;}
  inline OivSceneGraph* getSceneGraph() {return m_sceneGraph;}

  void updateGui(); //update according to new file loaded  

  inline Widget getWidget() {return m_widget;}
  
  SoTopLevelDialog* m_topLevelDialog;

private:
  Widget buildGui(Widget window);

  
  void initVisualizationPanel();  
  void initComputePanel();  
  void initLDMPanel();  


  void buildAuditorSlice(int id);


  OivSceneGraph*    m_sceneGraph;

  SbVec3i32         m_LdmDim;
  std::string       m_ivDialogFile;

  Widget m_widget;

};


#endif


