/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Federico Gamba (Nov 2009)
**=======================================================================*/

#ifndef _LOGICALSLICEFILTER_H_
#define _LOGICALSLICEFILTER_H_


#include <Inventor/SbLinear.h>
#include <MeshViz/3Ddata/PbCell.h>
#include <MeshViz/nodes/PoCellFilter.h>

class EclipseMesh;

class LogicalSliceFilter : public PoCellFilter 
{
  SO_NODE_HEADER(LogicalSliceFilter);

public :

  LogicalSliceFilter();
  ~LogicalSliceFilter();

#if defined(_WIN32) && defined(BUILDING_DLL)
   // When building the node as a DLL under Win32 we must explicitly
   // declare this entry point as visible outside the DLL.  The macro
   // BUILDING_DLL is defined in the node's source file.
   _declspec(dllexport)
#endif
  static void initClass();

  static void exitClass();

  SbBool acceptCell(int cell_index, float cell_value) const;
  void setAxis(int Axis);
  void setValue(int Value);
  void setMesh(EclipseMesh* mesh);

  virtual void write(SoWriteAction *action);

protected:
	int m_ni;
	int m_nj;
	int m_nk;

	int m_Axis;
	int m_Value;
	EclipseMesh* m_Mesh;
  
	void cell_index_2_ijk (int cell_index, int& i,int& j,int& k) const;
	void checkValue();
};


#endif

