/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Federico Gamba (Nov 2009)
**=======================================================================*/

#ifndef _OIVSCENEGRAPH_H
#define _OIVSCENEGRAPH_H

#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/Gui/view/PoSceneView.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoTransform.h>
#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/nodes/SoShapeHints.h>
#include <Inventor/nodes/SoGradientBackground.h> 
#include <Inventor/nodes/SoClipPlane.h>
#include <Inventor/nodes/SoDrawStyle.h>
#include <Inventor/nodes/SoLightModel.h>
#include <Inventor/nodes/SoIndexedLineSet.h>
#include <Inventor/nodes/SoPickStyle.h>

#include <Inventor/nodes/SoOrthographicCamera.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/nodes/SoBaseColor.h> 
#include <Inventor/nodes/SoTranslation.h> 

#include <VolumeViz/nodes/SoVolumeGroup.h>
#include <VolumeViz/nodes/SoVolumeData.h>
#include <VolumeViz/nodes/SoVolumeRender.h>
#include <VolumeViz/nodes/SoVolumeRendering.h>
#include <VolumeViz/nodes/SoVolumeData.h>
#include <VolumeViz/nodes/SoVolumeRender.h>
#include <VolumeViz/nodes/SoVolumeSkin.h>
#include <VolumeViz/nodes/SoOrthoSlice.h>
#include <VolumeViz/nodes/SoObliqueSlice.h>
#include <VolumeViz/nodes/SoVolumeRenderingQuality.h>
#include <VolumeViz/nodes/SoVolumeIsosurface.h>
#include <VolumeViz/nodes/SoVolumeClippingGroup.h>
#include <VolumeViz/nodes/SoUniformGridClipping.h>
#include <VolumeViz/readers/SoVRGenericFileReader.h>
#include <VolumeViz/readers/SoVRSegyFileReader.h>

#include <LDM/nodes/SoTransferFunction.h>
#include <LDM/nodes/SoROI.h>
#include <LDM/nodes/SoTransferFunction.h>
#include <LDM/nodes/SoGeometryPriority.h> 
#include <LDM/nodes/SoDataRange.h>
#include <LDM/manips/SoROIManip.h>
#include <LDM/SoLDMDataAccess.h> 
#include <LDM/SoVolumeHistogram.h>

#include <MeshViz/nodes/PoDomain.h> 
#include <MeshViz/graph/PoSingleHistogram.h> 

class GuiDialogViz;

#define NUM_SLICE 3
#define SCENE_SPLIT 0.2f
#define USE_POSCENEVIEW 1

class OivSceneGraph {

public:
  OivSceneGraph(const SbString& LdmFilename);

  inline void setGui(GuiDialogViz* gui) { m_gui = gui; }
  inline SbVec3s getLdmDim() { return m_LdmDim;}

  inline SoSeparator* getRoot() {return m_Root;}
  inline SoGradientBackground* getBackground() {return m_Background;}

#ifdef USE_POSCENEVIEW
  inline PoSceneView* get3DScene() {return m_3DScene;}
#else
  inline SoSeparator* get3DScene() {return m_3DScene;}
#endif

  inline SoTransform* getTransform() {return m_Transform;}  

  inline SoSeparator* getVolumeRoot() {return m_VolumeRoot;}

  inline SoVolumeData* getVolumeData() {return m_VolumeData;}

  inline SoSwitch* getSwitchSlices() {return m_SwitchSlices;}

  inline SoSwitch* getSwitchSlice(int sliceId) {return m_SwitchSlice[sliceId];}
  inline SoSlice* getSlice(int sliceId) {return m_Slice[sliceId];}

  inline SoTransferFunction* getTransferFunction() {return m_TransferFunction;}
  inline SoDataRange* getDataRange() {return m_DataRange;}

  inline SoSeparator* getBoundingBox() {return m_BoundingBox;}
  inline SoROIManip* getROIManip() { return m_ROIManip;}


  inline SoSeparator* getAxes() {return m_Axes;}
  inline SoSwitch* getSwitchAxes() {return m_SwitchAxes;}

  inline PoSceneView* get2DScene() {return m_2DScene;}
  inline PoSingleHistogram* getHistogram() {return m_histo;}

  inline SoOrthographicCamera* get2DCamera() {return m_2DCamera;}
  inline SoPerspectiveCamera* get3DCamera() {return m_3DCamera;}

  inline int getResolution() {return m_Resolution;}
  inline void setResolution(int res) {m_Resolution=res;}

  void updateHistogram();

protected:
  SoSeparator* createSceneGraph();
  void assembleSceneGraph();
  void setFilename (const SbString &LdmFilename);

  void createBBox();

  void loadAvizoColormap(const SbString &Filename);
  void createHistogram();

protected:
	SbString m_LdmFilename;

	SoSeparator *m_Root;
	SoGradientBackground *m_Background;

#ifdef USE_POSCENEVIEW
	PoSceneView *m_3DScene;	
#else
    SoSeparator *m_3DScene;
#endif
	SoPerspectiveCamera* m_3DCamera;

	SoSeparator *m_3DRoot;

	SoTransform *m_Transform;

	SoSeparator *m_VolumeRoot;
	SoVolumeData *m_VolumeData;
	SoSwitch *m_SwitchSlices;

	SoSlice *m_Slice[NUM_SLICE];
	SoSwitch *m_SwitchSlice[NUM_SLICE];

	SoTransferFunction *m_TransferFunction;
	SoDataRange *m_DataRange;

	SoROIManip *m_ROIManip;
	SoSwitch* m_SwitchVolRend;

	SoVolumeRenderingQuality* m_VolRendQ;
	SoVolumeSkin* m_VolSkin;
	SoVolumeRender* m_VolRend;

	SoSeparator* m_BoundingBox;

	SoSeparator* m_Axes;
	SoSwitch *m_SwitchAxes;

	GuiDialogViz* m_gui;

	SbVec3i32 m_LdmDim;
	SbBox3f m_Extent;

	PoSceneView* m_2DScene;
	SoSeparator* m_2DRoot;
	SoOrthographicCamera* m_2DCamera;

    PoSingleHistogram *m_histo; 

	double m_DataMin;
	double m_DataMax;

	int m_LDM_RAM;
	int m_LDM_GPU_3D;
	int m_LDM_GPU_2D;

	bool m_ComputeOnOff;
	bool m_ComputeCPUGPU;

	int m_Resolution;
	float m_histo256_f[256];

};

#endif

