//!oiv_include <Inventor/oivShaderVariables.h>

uniform sampler2D colormap;
uniform sampler2D inputData;

uniform int transparentBorders;

void main()
{
   vec2 coord = OivFragmentTexCoord(1).st;
   vec4 value = texture(inputData, coord);
   vec4 color = texture(colormap,vec2(value.r,0.5));
   
   if (transparentBorders > 0)
   {
     if (value.r < 0.01)
       color.a = 0.0;

     if (value.r > 0.99)
       color.a = 0.0;
   }
   
   OivFragmentOutput(color);
}
